<?php
/**
 * Neo HTML Protector global
 */

defined('ABSPATH') or die('Oh! No!');

$neohp_redirect_default = __('https://google.co.jp', 'neo-html-protector');

$neohp_nocookienojs_default =
	__('このウェブサイトをご利用いただくには、CookieとJavaScriptを有効にしていただく必要があります', 'neo-html-protector');

$neohp_imagedownload_default =
	sprintf("%s\\n\\n%s\\n\\n%s\\n\\n%s\\n%s\\n%s\\n"
		, 'WARNING'
		, 'Downloading images is prohibited.'
		, 'The following information has been sent to the server.'
		, 'Your IP address: $IP'
		, 'Your User-agent: $UA'
		, 'Event: Image downloading'
	);

$neohp_debugmode_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('セキュリティ並びにコンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('デバッグモード、コンソールの起動は禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたの押下したキー', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_rightclick_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('コンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('右クリックは禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが押下したキー', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_printout_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('コンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('印刷、PDFへの保存は禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが押下したキー', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_printscreen_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('コンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('スクリーンショットは禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが押下したキー', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_ctrlshift_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('セキュリティ並びにコンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('スクリーンショット、デバッグモード等の起動は禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが押下したキー', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_save_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('コンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('ページの保存は禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが押下したキー', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_copycut_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('コンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('コピー、カットは禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが起こしたイベント', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_textselect_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('コンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('テキストの選択は禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが起こしたイベント', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_htmlsource_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('セキュリティ並びにコンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('HTMLソース表示は禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが押下したキー', 'neo-html-protector') . ': $KEY'
		, __('リダイレクトをします', 'neo-html-protector')
	);

$neohp_htmlprotect_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('セキュリティ並びにコンテンツ保護のため一部の機能を制限しています', 'neo-html-protector')
		, __('HTMLソース表示は禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが起こしたイベント', 'neo-html-protector') . ': $KEY'
	);

$neohp_nonceerror_default =
	sprintf("%s\\n%s\\n%s\\n%s\\n%s\\n%s\\n%s"
		, __('通常とは異なる方法でのアクセスや操作が検出されました', 'neo-html-protector')
		, __('不正アクセスは禁止されています', 'neo-html-protector')
		, __('以下の情報がサーバーに送信されました', 'neo-html-protector')
		, __('あなたのIPアドレス', 'neo-html-protector') . ': $IP'
		, __('あなたの端末とブラウザ', 'neo-html-protector') . ': $UA'
		, 'URL: $URL'
		, __('あなたが起こしたイベント', 'neo-html-protector') . ': $KEY'
	);

$neohp_lang = [
	'ar'=>		__('アラビア語', 'neo-html-protector'),
	'br'=>		__('ブルガリア語', 'neo-html-protector'),
	'cs'=>		__('チェコ語', 'neo-html-protector'),
	'da'=>		__('デンマーク語', 'neo-html-protector'),
	'de'=>		__('ドイツ語', 'neo-html-protector'),
	'el'=>		__('現代ギリシア語', 'neo-html-protector'),
	'en'=>		__('英語', 'neo-html-protector'),
	'en_GB'=>	__('イギリス英語', 'neo-html-protector'),
	'en_US'=>	__('アメリカ英語', 'neo-html-protector'),
	'es'=>		__('スペイン語', 'neo-html-protector'),
	'et'=>		__('エストニア語', 'neo-html-protector'),
	'fi'=>		__('フィンランド語', 'neo-html-protector'),
	'fr'=>		__('フランス語', 'neo-html-protector'),
	'hu'=>		__('ハンガリー語', 'neo-html-protector'),
	'id'=>		__('インドネシア語', 'neo-html-protector'),
	'it'=>		__('イタリア語', 'neo-html-protector'),
	'ja'=>		__('日本語', 'neo-html-protector'),
	'ko'=>		__('朝鮮語', 'neo-html-protector'),
	'lt'=>		__('リトアニア語', 'neo-html-protector'),
	'lv'=>		__('ラトビア語', 'neo-html-protector'),
	'no'=>		__('ノルウェー語', 'neo-html-protector'),
	'nl'=>		__('オランダ語', 'neo-html-protector'),
	'pl'=>		__('ポーランド語', 'neo-html-protector'),
	'pt'=>		__('ポルトガリア語', 'neo-html-protector'),
	'pt_BR'=>	__('ブラジルポルトガル語', 'neo-html-protector'),
	'pt_PT'=>	__('ヨーロピアンポルトガル語', 'neo-html-protector'),
	'ro'=>		__('ルーマニア語', 'neo-html-protector'),
	'ru'=>		__('ロシア語', 'neo-html-protector'),
	'sk'=>		__('スロバキア語', 'neo-html-protector'),
	'sl'=>		__('スロベニア語', 'neo-html-protector'),
	'sv'=>		__('スウェーデン語', 'neo-html-protector'),
	'tr'=>		__('トルコ語', 'neo-html-protector'),
	'uk'=>		__('ウクライナ語', 'neo-html-protector'),
	'zh'=>		__('中国語', 'neo-html-protector'),
	'zh_CN'=>	__('簡体中国語', 'neo-html-protector'),
	'zh_TW'=>	__('繁体中国語', 'neo-html-protector')
];

	// https://rakko.tools/tools/68/
	$warning_ascii_art=[
		'ALERT 1943'=>'
  ##     ####     ### ###  ### ##   #### ##
   ##     ##       ##  ##   ##  ##  # ## ##
 ## ##    ##       ##       ##  ##    ##
 ##  ##   ##       ## ##    ## ##     ##
 ## ###   ##       ##       ## ##     ##
 ##  ##   ##  ##   ##  ##   ##  ##    ##
###  ##  ### ###  ### ###  #### ##   ####
',		'ALERT 4max'=>'
   db    88     888888 88""Yb 888888
  dPYb   88     88__   88__dP   88
 dP__Yb  88  .o 88""   88"Yb    88
dP""""Yb 88ood8 888888 88  Yb   88
',		'ALERT 4x4_offr'=>'
   ##     ##       ######   #####    ######
  ####    ##       ##       ##  ##     ##
 ##  ##   ##       ##       ##  ##     ##
 ######   ##       ####     #####      ##
 ##  ##   ##       ##       ####       ##
 ##  ##   ##       ##       ## ##      ##
 ##  ##   ######   ######   ##  ##     ##
',		'ALERT 64f1'=>'
  ###    ##       ####     ######   #######
 #####   ##       ##       ###  ##  #######
 ## ##   ##       #####    ###  ##  #######
##   ##  ##       ##       #######    ###
##   ##  ##       ##       ######     ###
## ####  #######  #######  ### ###    ###
## ####  #######  #######  ### ###    ###
## ####  #######  #######  ### ###    ###
',		'ALERT alligator'=>'
          :::        :::        ::::::::::       :::::::::   :::::::::::
       :+: :+:      :+:        :+:              :+:    :+:      :+:
     +:+   +:+     +:+        +:+              +:+    +:+      +:+
   +#++:++#++:    +#+        +#++:++#         +#++:++#:       +#+
  +#+     +#+    +#+        +#+              +#+    +#+      +#+
 #+#     #+#    #+#        #+#              #+#    #+#      #+#
###     ###    ########## ##########       ###    ###      ###
',		'ALERT alligator2'=>'
    :::     :::        :::::::::: :::::::::  :::::::::::
  :+: :+:   :+:        :+:        :+:    :+:     :+:
 +:+   +:+  +:+        +:+        +:+    +:+     +:+
+#++:++#++: +#+        +#++:++#   +#++:++#:      +#+
+#+     +#+ +#+        +#+        +#+    +#+     +#+
#+#     #+# #+#        #+#        #+#    #+#     #+#
###     ### ########## ########## ###    ###     ###
',		'ALERT alphabet'=>'
 AA  L    EEEE RRRR  TTTTTT
A  A L    E    R   R   TT
AAAA L    EEE  RRRR    TT
A  A L    E    R R     TT
A  A LLLL EEEE R  RR   TT
',		'ALERT aquaplan'=>'
   ##     ##       ######   #####    ######
  ####    ##       ##       ##  ##     ##
 ##  ##   ##       ##       ##  ##     ##
 ######   ##       ####     #####      ##
 ##  ##   ##       ##       ####       ##
 ##  ##   ##       ##       ## ##      ##
 ##  ##   ######   ######   ##  ##     ##
',		'ALERT asc'=>'
  ######   #        ######  ######   #######
  #    #   #        #       #    #      #
  #    #   #        #       #    #      #
 #######  ##       #####    #######    ##
 ##    #  ##       ##       ##    #    ##
 ##    #  ##       ##       ##    #    ##
 ##    #  #######  #######  ##    #    ##
',		'ALERT banner'=>'
   #    #       ####### ######  #######
  # #   #       #       #     #    #
 #   #  #       #       #     #    #
#     # #       #####   ######     #
####### #       #       #   #      #
#     # #       #       #    #     #
#     # ####### ####### #     #    #
',		'ALERT banner3'=>'
   ###    ##       ######## ########  ########
  ## ##   ##       ##       ##     ##    ##
 ##   ##  ##       ##       ##     ##    ##
##     ## ##       ######   ########     ##
######### ##       ##       ##   ##      ##
##     ## ##       ##       ##    ##     ##
##     ## ######## ######## ##     ##    ##
',		'ALERT banner3-d'=>'
:::\'###::::\'##:::::::\'########:\'########::\'########:
::\'## ##::: ##::::::: ##.....:: ##.... ##:... ##..::
:\'##:. ##:: ##::::::: ##::::::: ##:::: ##:::: ##::::
\'##:::. ##: ##::::::: ######::: ########::::: ##::::
 #########: ##::::::: ##...:::: ##.. ##:::::: ##::::
 ##.... ##: ##::::::: ##::::::: ##::. ##::::: ##::::
 ##:::: ##: ########: ########: ##:::. ##:::: ##::::
..:::::..::........::........::..:::::..:::::..:::::
',		'ALERT banner4'=>'
....###....##.......########.########..########
...##.##...##.......##.......##.....##....##...
..##...##..##.......##.......##.....##....##...
.##.....##.##.......######...########.....##...
.#########.##.......##.......##...##......##...
.##.....##.##.......##.......##....##.....##...
.##.....##.########.########.##.....##....##...
',		'ALERT basic'=>'
 .d8b.  db      d88888b d8888b. d888888b
d8\' \`8b 88      88\'     88  \`8D \`~~88~~\'
88ooo88 88      88ooooo 88oobY\'    88
88~~~88 88      88~~~~~ 88\`8b      88
88   88 88booo. 88.     88 \`88.    88
YP   YP Y88888P Y88888P 88   YD    YP
',		'ALERT broadway'=>'
         .8.          8 8888         8 8888888888   8 888888888o.   8888888 8888888888
        .888.         8 8888         8 8888         8 8888    \`88.        8 8888
       :88888.        8 8888         8 8888         8 8888     \`88        8 8888
      . \`88888.       8 8888         8 8888         8 8888     ,88        8 8888
     .8. \`88888.      8 8888         8 888888888888 8 8888.   ,88\'        8 8888
    .8\`8. \`88888.     8 8888         8 8888         8 888888888P\'         8 8888
   .8\' \`8. \`88888.    8 8888         8 8888         8 8888\`8b             8 8888
  .8\'   \`8. \`88888.   8 8888         8 8888         8 8888 \`8b.           8 8888
 .888888888. \`88888.  8 8888         8 8888         8 8888   \`8b.         8 8888
.8\'       \`8. \`88888. 8 888888888888 8 888888888888 8 8888     \`88.       8 8888
',		'ALERT contrast'=>'
..%%%%...%%......%%%%%%..%%%%%...%%%%%%.
.%%..%%..%%......%%......%%..%%....%%...
.%%%%%%..%%......%%%%....%%%%%.....%%...
.%%..%%..%%......%%......%%..%%....%%...
.%%..%%..%%%%%%..%%%%%%..%%..%%....%%...
........................................
',		'ALERT dotmatrix'=>'
       _           _                 _  _  _  _  _     _  _  _  _        _  _  _  _  _
     _(_)_        (_)               (_)(_)(_)(_)(_)   (_)(_)(_)(_) _    (_)(_)(_)(_)(_)
   _(_) (_)_      (_)               (_)               (_)         (_)         (_)
 _(_)     (_)_    (_)               (_) _  _          (_) _  _  _ (_)         (_)
(_) _  _  _ (_)   (_)               (_)(_)(_)         (_)(_)(_)(_)            (_)
(_)(_)(_)(_)(_)   (_)               (_)               (_)   (_) _             (_)
(_)         (_)   (_) _  _  _  _    (_) _  _  _  _    (_)      (_) _          (_)
(_)         (_)   (_)(_)(_)(_)(_)   (_)(_)(_)(_)(_)   (_)         (_)         (_)
',		'ALERT impossible'=>'
         _                   _              _               _             _
        / /\                _\ \           /\ \            /\ \          /\ \
       / /  \              /\__ \         /  \ \          /  \ \         \_\ \
      / / /\ \            / /_ \_\       / /\ \ \        / /\ \ \        /\__ \
     / / /\ \ \          / / /\/_/      / / /\ \_\      / / /\ \_\      / /_ \ \
    / / /  \ \ \        / / /          / /_/_ \/_/     / / /_/ / /     / / /\ \ \
   / / /___/ /\ \      / / /          / /____/\       / / /__\/ /     / / /  \/_/
  / / /_____/ /\ \    / / / ____     / /\____\/      / / /_____/     / / /
 / /_________/\ \ \  / /_/_/ ___/\  / / /______     / / /\ \ \      / / /
/ / /_       __\ \_\/_______/\__\/ / / /_______\   / / /  \ \ \    /_/ /
\_\___\     /____/_/\_______\/     \/__________/   \/_/    \_\/    \_\/
',		'ALERT letters'=>'
  AAA   LL      EEEEEEE RRRRRR  TTTTTTT
 AAAAA  LL      EE      RR   RR   TTT
AA   AA LL      EEEEE   RRRRRR    TTT
AAAAAAA LL      EE      RR  RR    TTT
AA   AA LLLLLLL EEEEEEE RR   RR   TTT
',		'ALERT nancyj'=>'
 .d888888  dP         88888888b  888888ba  d888888P
d8\'    88  88         88         88    \`8b    88
88aaaaa88a 88        a88aaaa    a88aaaa8P\'    88
88     88  88         88         88   \`8b.    88
88     88  88         88         88     88    88
88     88  88888888P  88888888P  dP     dP    dP
',		'ALERT nancyj-underlined'=>'
 .d888888  dP         88888888b  888888ba  d888888P
d8\'    88  88         88         88    \`8b    88
88aaaaa88a 88        a88aaaa    a88aaaa8P\'    88
88     88  88         88         88   \`8b.    88
88     88  88         88         88     88    88
88     88  88888888P  88888888P  dP     dP    dP
oooooooooooooooooooooooooooooooooooooooooooooooooooo
',		'ALERT o8'=>'
     o      ooooo       ooooooooooo oooooooooo  ooooooooooo
    888      888         888    88   888    888 88  888  88
   8  88     888         888ooo8     888oooo88      888
  8oooo88    888      o  888    oo   888  88o       888
o88o  o888o o888ooooo88 o888ooo8888 o888o  88o8    o888o
',		'ALERT os2'=>'
___ooo____oo______ooooooo_ooooooo___oooooooo_
_oo___oo__oo______oo______oo____oo_____oo____
oo_____oo_oo______oooo____oo____oo_____oo____
ooooooooo_oo______oo______ooooooo______oo____
oo_____oo_oo______oo______oo____oo_____oo____
oo_____oo_ooooooo_ooooooo_oo_____oo____oo____
_____________________________________________
',		'ALERT vortron'=>'
   ##     ##         #####    ####   #######
  ####    ##        ##       ##  ##    ##
  ## ##   ##       ##       ##   ##    ##
 ##   ##  ##       ######   ######     ##
 #######  ##       ##       ####       ##
 ##   ##  ###      ##       ## ##      ##
 ##   ##   ######  #######  ##  ##     ##
',


		'WARNING 1943'=>'
##   ##    ##     ### ##   ###  ##    ####   ###  ##   ## ##
##   ##     ##     ##  ##    ## ##     ##      ## ##  ##   ##
##   ##   ## ##    ##  ##   # ## #     ##     # ## #  ##
## # ##   ##  ##   ## ##    ## ##      ##     ## ##   ##  ###
# ### #   ## ###   ## ##    ##  ##     ##     ##  ##  ##   ##
 ## ##    ##  ##   ##  ##   ##  ##     ##     ##  ##  ##   ##
##   ##  ###  ##  #### ##  ###  ##    ####   ###  ##   ## ##
',		'WARNING 3-d'=>'
 **       **     **     *******   ****     ** ** ****     **   ********
/**      /**    ****   /**////** /**/**   /**/**/**/**   /**  **//////**
/**   *  /**   **//**  /**   /** /**//**  /**/**/**//**  /** **      //
/**  *** /**  **  //** /*******  /** //** /**/**/** //** /**/**
/** **/**/** **********/**///**  /**  //**/**/**/**  //**/**/**    *****
/**** //****/**//////**/**  //** /**   //****/**/**   //****//**  ////**
/**/   ///**/**     /**/**   //**/**    //***/**/**    //*** //********
//       // //      // //     // //      /// // //      ///   ////////
',		'WARNING 4max'=>'
Yb        dP    db    88""Yb 88b 88 88 88b 88  dP""b8
 Yb  db  dP    dPYb   88__dP 88Yb88 88 88Yb88 dP   \`"
  YbdPYbdP    dP__Yb  88"Yb  88 Y88 88 88 Y88 Yb  "88
   YP  YP    dP""""Yb 88  Yb 88  Y8 88 88  Y8  YboodP
',		'WARNING 4x4_offr'=>'
 ##   ##    ##     #####    ##  ##    ####    ##  ##    ####
 ##   ##   ####    ##  ##   ### ##     ##     ### ##   ##  ##
 ##   ##  ##  ##   ##  ##   ######     ##     ######   ##
 ## # ##  ######   #####    ######     ##     ######   ## ###
 #######  ##  ##   ####     ## ###     ##     ## ###   ##  ##
 ### ###  ##  ##   ## ##    ##  ##     ##     ##  ##   ##  ##
 ##   ##  ##  ##   ##  ##   ##  ##    ####    ##  ##    ####
',		'WARNING 5lineoblique'=>'
                                                       ___   ___
||   / |  / /     // | |     //   ) )     /|    / /       / /        /|    / /     //   ) )
||  /  | / /     //__| |    //___/ /     //|   / /       / /        //|   / /     //
|| / /||/ /     / ___  |   / ___ (      // |  / /       / /        // |  / /     //  ____
||/ / |  /     //    | |  //   | |     //  | / /       / /        //  | / /     //    / /
|  /  | /     //     | | //    | |    //   |/ /     __/ /___     //   |/ /     ((____/ /
',		'WARNING 5x7'=>'
#  #   ##   ###   #  #  ###   #  #   ##
#  #  #  #  #  #  ## #   #    ## #  #  #
#  #  #  #  #  #  ## #   #    ## #  #
####  ####  ###   # ##   #    # ##  # ##
####  #  #  # #   # ##   #    # ##  #  #
#  #  #  #  #  #  #  #  ###   #  #   ###
',		'WARNING 64f1'=>'
###  ##    ###    ######   ###  ##  #######  ###  ##   #####
###  ##   #####   ###  ##  ###  ##    ###    ###  ##  ###
###  ##   ## ##   ###  ##  #### ##    ###    #### ##  ### ##
###  ##  ##   ##  #######  #######    ###    #######  ###  ##
#######  ##   ##  ######   #######    ###    #######  ###  ##
#######  ## ####  ### ###  ### ###  #######  ### ###  #######
### ###  ## ####  ### ###  ###  ##  #######  ###  ##  #######
##   ##  ## ####  ### ###  ###  ##  #######  ###  ##   #####
',		'WARNING 6x10'=>'
 #   #    #    ####   #   #   ###   #   #   ###
 #   #   # #   #   #  #   #    #    #   #  #   #
 #   #  #   #  #   #  ##  #    #    ##  #  #
 # # #  #   #  ####   # # #    #    # # #  #
 # # #  #####  # #    #  ##    #    #  ##  #  ##
 ## ##  #   #  #  #   #   #    #    #   #  #   #
 #   #  #   #  #   #  #   #   ###   #   #   ###
',		'WARNING advenger'=>'
##   ##    ###    ######   ##   ##   ######  ##   ##   #####
##   ##   ## ##    ##  ##  ###  ##     ##    ###  ##  ##   ##
##   ##  ##   ##   ##  ##  #### ##     ##    #### ##  ##
## # ##  ##   ##   #####   #######     ##    #######  ## ####
#######  #######   ## ##   ## ####     ##    ## ####  ##   ##
### ###  ##   ##   ## ##   ##  ###     ##    ##  ###  ##   ##
##   ##  ##   ##  #### ##  ##   ##   ######  ##   ##   #####
',		'WARNING alligator'=>'
    :::       :::           :::        :::::::::       ::::    :::       :::::::::::       ::::    :::       ::::::::
   :+:       :+:         :+: :+:      :+:    :+:      :+:+:   :+:           :+:           :+:+:   :+:      :+:    :+:
  +:+       +:+        +:+   +:+     +:+    +:+      :+:+:+  +:+           +:+           :+:+:+  +:+      +:+
 +#+  +:+  +#+       +#++:++#++:    +#++:++#:       +#+ +:+ +#+           +#+           +#+ +:+ +#+      :#:
+#+ +#+#+ +#+       +#+     +#+    +#+    +#+      +#+  +#+#+#           +#+           +#+  +#+#+#      +#+   +#+#
#+#+# #+#+#        #+#     #+#    #+#    #+#      #+#   #+#+#           #+#           #+#   #+#+#      #+#    #+#
###   ###         ###     ###    ###    ###      ###    ####       ###########       ###    ####       ########
',		'WARNING alligator2'=>'
:::       :::     :::     :::::::::  ::::    ::: ::::::::::: ::::    :::  ::::::::
:+:       :+:   :+: :+:   :+:    :+: :+:+:   :+:     :+:     :+:+:   :+: :+:    :+:
+:+       +:+  +:+   +:+  +:+    +:+ :+:+:+  +:+     +:+     :+:+:+  +:+ +:+
+#+  +:+  +#+ +#++:++#++: +#++:++#:  +#+ +:+ +#+     +#+     +#+ +:+ +#+ :#:
+#+ +#+#+ +#+ +#+     +#+ +#+    +#+ +#+  +#+#+#     +#+     +#+  +#+#+# +#+   +#+#
 #+#+# #+#+#  #+#     #+# #+#    #+# #+#   #+#+#     #+#     #+#   #+#+# #+#    #+#
  ###   ###   ###     ### ###    ### ###    #### ########### ###    ####  ########
',		'WARNING alligator3'=>'
:::       :::     :::     :::::::::  ::::    ::: ::::::::::: ::::    :::  ::::::::
:+:       :+:   :+: :+:   :+:    :+: :+:+:   :+:     :+:     :+:+:   :+: :+:    :+:
+:+       +:+  +:+   +:+  +:+    +:+ :+:+:+  +:+     +:+     :+:+:+  +:+ +:+
+#+  +:+  +#+ +#++:++#++: +#++:++#:  +#+ +:+ +#+     +#+     +#+ +:+ +#+ :#:
+#+ +#+#+ +#+ +#+     +#+ +#+    +#+ +#+  +#+#+#     +#+     +#+  +#+#+# +#+   +#+#
 #+#+# #+#+#  #+#     #+# #+#    #+# #+#   #+#+#     #+#     #+#   #+#+# #+#    #+#
  ###   ###   ###     ### ###    ### ###    #### ########### ###    ####  ########
',		'WARNING aquaplan'=>'
 ##   ##    ##     #####    ##  ##    ####    ##  ##    ####
 ##   ##   ####    ##  ##   ### ##     ##     ### ##   ##  ##
 ##   ##  ##  ##   ##  ##   ######     ##     ######   ##
 ## # ##  ######   #####    ######     ##     ######   ## ###
 #######  ##  ##   ####     ## ###     ##     ## ###   ##  ##
 ### ###  ##  ##   ## ##    ##  ##     ##     ##  ##   ##  ##
 ##   ##  ##  ##   ##  ##   ##  ##    ####    ##  ##    ####
',		'WARNING assalt_m'=>'
 ##  ###   ######  ######   ##  ###  #######  ##  ###  #######
 ##  ###   ##  ##  ##  ##   ### ###    ###    ### ###  ##   ##
 ##  ###   ##  ##  ##  ##   #######    ###    #######  ##
 ## ####  #######  #######  ## ####    ###    ## ####  ## ####
 #######  ###  ##  ### ###  ##  ###    ###    ##  ###  ##  ###
 #######  ###  ##  ### ###  ##  ###    ###    ##  ###  ##  ###
 ##  ###  ###  ##  ### ###  ##  ###  #######  ##  ###  #######
',		'WARNING asslt_m'=>'
 ##  ###   ######  ######   ##  ###  #######  ##  ###  #######
 ##  ###   ##  ##  ##  ##   ### ###    ###    ### ###  ##   ##
 ##  ###   ##  ##  ##  ##   #######    ###    #######  ##
 ## ####  #######  #######  ## ####    ###    ## ####  ## ####
 #######  ###  ##  ### ###  ##  ###    ###    ##  ###  ##  ###
 #######  ###  ##  ### ###  ##  ###    ###    ##  ###  ##  ###
 ##  ###  ###  ##  ### ###  ##  ###  #######  ##  ###  #######
',		'WARNING banner'=>'
#     #    #    ######  #     # ### #     #  #####
#  #  #   # #   #     # ##    #  #  ##    # #     #
#  #  #  #   #  #     # # #   #  #  # #   # #
#  #  # #     # ######  #  #  #  #  #  #  # #  ####
#  #  # ####### #   #   #   # #  #  #   # # #     #
#  #  # #     # #    #  #    ##  #  #    ## #     #
 ## ##  #     # #     # #     # ### #     #  #####
',		'WARNING banner3'=>'
##      ##    ###    ########  ##    ## #### ##    ##  ######
##  ##  ##   ## ##   ##     ## ###   ##  ##  ###   ## ##    ##
##  ##  ##  ##   ##  ##     ## ####  ##  ##  ####  ## ##
##  ##  ## ##     ## ########  ## ## ##  ##  ## ## ## ##   ####
##  ##  ## ######### ##   ##   ##  ####  ##  ##  #### ##    ##
##  ##  ## ##     ## ##    ##  ##   ###  ##  ##   ### ##    ##
 ###  ###  ##     ## ##     ## ##    ## #### ##    ##  ######
',		'WARNING banner4'=>'
.##......##....###....########..##....##.####.##....##..######..
.##..##..##...##.##...##.....##.###...##..##..###...##.##....##.
.##..##..##..##...##..##.....##.####..##..##..####..##.##.......
.##..##..##.##.....##.########..##.##.##..##..##.##.##.##...####
.##..##..##.#########.##...##...##..####..##..##..####.##....##.
.##..##..##.##.....##.##....##..##...###..##..##...###.##....##.
..###..###..##.....##.##.....##.##....##.####.##....##..######..
',		'WARNING c_consen'=>'
 ##   ##   ####    #####    ##  ##    ####    ##  ##    #####
 ## # ##  ##  ##   ##  ##   ### ##     ##     ### ##   ##
 ## # ##  ######   #####    ######     ##     ######   ## ###
 #######  ##  ##   ## ##    ## ###     ##     ## ###   ##  ##
  ## ##   ##  ##   ##  ##   ##  ##    ####    ##  ##    ####
',		'WARNING colossal'=>'
888       888        d8888 8888888b.  888b    888 8888888 888b    888  .d8888b.
888   o   888       d88888 888   Y88b 8888b   888   888   8888b   888 d88P  Y88b
888  d8b  888      d88P888 888    888 88888b  888   888   88888b  888 888    888
888 d888b 888     d88P 888 888   d88P 888Y88b 888   888   888Y88b 888 888
888d88888b888    d88P  888 8888888P"  888 Y88b888   888   888 Y88b888 888  88888
88888P Y88888   d88P   888 888 T88b   888  Y88888   888   888  Y88888 888    888
8888P   Y8888  d8888888888 888  T88b  888   Y8888   888   888   Y8888 Y88b  d88P
888P     Y888 d88P     888 888   T88b 888    Y888 8888888 888    Y888  "Y8888P88
',		'WARNING doh'=>'
                                                                                                   iiii
                                                                                                  i::::i
                                                                                                   iiii

wwwwwww           wwwww           wwwwwww  aaaaaaaaaaaaa   rrrrr   rrrrrrrrr   nnnn  nnnnnnnn    iiiiiii nnnn  nnnnnnnn       ggggggggg   ggggg
 w:::::w         w:::::w         w:::::w   a::::::::::::a  r::::rrr:::::::::r  n:::nn::::::::nn  i:::::i n:::nn::::::::nn    g:::::::::ggg::::g
  w:::::w       w:::::::w       w:::::w    aaaaaaaaa:::::a r:::::::::::::::::r n::::::::::::::nn  i::::i n::::::::::::::nn  g:::::::::::::::::g
   w:::::w     w:::::::::w     w:::::w              a::::a rr::::::rrrrr::::::rnn:::::::::::::::n i::::i nn:::::::::::::::ng::::::ggggg::::::gg
    w:::::w   w:::::w:::::w   w:::::w        aaaaaaa:::::a  r:::::r     r:::::r  n:::::nnnn:::::n i::::i   n:::::nnnn:::::ng:::::g     g:::::g
     w:::::w w:::::w w:::::w w:::::w       aa::::::::::::a  r:::::r     rrrrrrr  n::::n    n::::n i::::i   n::::n    n::::ng:::::g     g:::::g
      w:::::w:::::w   w:::::w:::::w       a::::aaaa::::::a  r:::::r              n::::n    n::::n i::::i   n::::n    n::::ng:::::g     g:::::g
       w:::::::::w     w:::::::::w       a::::a    a:::::a  r:::::r              n::::n    n::::n i::::i   n::::n    n::::ng::::::g    g:::::g
        w:::::::w       w:::::::w        a::::a    a:::::a  r:::::r              n::::n    n::::ni::::::i  n::::n    n::::ng:::::::ggggg:::::g
         w:::::w         w:::::w         a:::::aaaa::::::a  r:::::r              n::::n    n::::ni::::::i  n::::n    n::::n g::::::::::::::::g
          w:::w           w:::w           a::::::::::aa:::a r:::::r              n::::n    n::::ni::::::i  n::::n    n::::n  gg::::::::::::::g
           www             www             aaaaaaaaaa  aaaa rrrrrrr              nnnnnn    nnnnnniiiiiiii  nnnnnn    nnnnnn    gggggggg::::::g
                                                                                                                                       g:::::g
                                                                                                                           gggggg      g:::::g
                                                                                                                           g:::::gg   gg:::::g
                                                                                                                            g::::::ggg:::::::g
                                                                                                                             gg:::::::::::::g
                                                                                                                               ggg::::::ggg
                                                                                                                                  gggggg
',		 'WARNING e_fist'=>'
 ##   ##   ####    #####    ##  ##   ######   ##  ##    ####
 ##   ##  ##  ##   ##  ##   ##  ##     ##     ##  ##   ##  ##
 ## # ##  ##  ##   ##  ##   ### ##     ##     ### ##   ##
 ## # ##  ######   #####    ######     ##     ######   ## ###
 #######  ##  ##   ## ##    ## ###     ##     ## ###   ##  ##
 ### ###  ##  ##   ##  ##   ##  ##     ##     ##  ##   ##  ##
 ##   ##  ##  ##   ##  ##   ##  ##   ######   ##  ##    ####
',		'WARNING finalass'=>'
##   ##   #####   ######   ###  ##   ######  ###  ##   #####
##   ##  ##   ##  ##   ##  #### ##     ##    #### ##  ##   ##
##   ##  ##   ##  ##   ##  #######     ##    #######  ##
##   ##  #######  ######   ## ####     ##    ## ####  ##  ###
#######  ##   ##  ## ##    ##  ###     ##    ##  ###  ##   ##
### ###  ##   ##  ##  ##   ##   ##     ##    ##   ##  ##   ##
##   ##  ##   ##  ##   ##  ##   ##   ######  ##   ##   #####
',		'WARNING home_pak'=>'
 ### ###    ###    ######   #### ##  #######  #### ##   #####
 ### ###   #####   ### ###  #### ##    ###    #### ##  ### ###
 #######  ### ###  ### ###  #######    ###    #######  ###
 #######  ### ###  ######   #######    ###    #######  ### ###
 ### ###  #######  ### ###  ### ###    ###    ### ###  ### ###
 ##   ##  ### ###  ### ###  ### ###  #######  ### ###   ### ##
',		'WARNING house_of'=>'
 ### ###   ####    #####    ##   ##  #####    ##   ##   ####
 ##   ##  ######    ## ##   # #  ##    ##     # #  ##  ##  ##
 ##   ##  ##  ##    ## ##   #### ##    ##     #### ##  ##
 ##   ##  ######    ####    ## ####    ##     ## ####  ######
 #######  ##  ##    ## ##   ##  ###    ##     ##  ###  ### ##
  ## ##   ##  ##    ##  ##  ##   ##  #####    ##   ##   #####
',		'WARNING letters'=>'
WW      WW   AAA   RRRRRR  NN   NN IIIII NN   NN   GGGG
WW      WW  AAAAA  RR   RR NNN  NN  III  NNN  NN  GG  GG
WW   W  WW AA   AA RRRRRR  NN N NN  III  NN N NN GG
 WW WWW WW AAAAAAA RR  RR  NN  NNN  III  NN  NNN GG   GG
  WW   WW  AA   AA RR   RR NN   NN IIIII NN   NN  GGGGGG
',		'WARNING nancyj'=>'
dP   dP   dP  .d888888   888888ba  888888ba  dP 888888ba   .88888.
88   88   88 d8\'    88   88    \\`8b 88    \\`8b 88 88    \\`8b d8\'   \\`88
88  .8P  .8P 88aaaaa88a a88aaaa8P\' 88     88 88 88     88 88
88  d8\'  d8\' 88     88   88   \\`8b. 88     88 88 88     88 88   YP88
88.d8P8.d8P  88     88   88     88 88     88 88 88     88 Y8.   .88
8888\' Y88\'   88     88   dP     dP dP     dP dP dP     dP  \\`88888\'
',		'WARNING nancyj-underlined'=>'
dP   dP   dP  .d888888   888888ba  888888ba  dP 888888ba   .88888.
88   88   88 d8\'    88   88    \\`8b 88    \\`8b 88 88    \\`8b d8\'   \\`88
88  .8P  .8P 88aaaaa88a a88aaaa8P\' 88     88 88 88     88 88
88  d8\'  d8\' 88     88   88   \\`8b. 88     88 88 88     88 88   YP88
88.d8P8.d8P  88     88   88     88 88     88 88 88     88 Y8.   .88
8888\' Y88\'   88     88   dP     dP dP     dP dP dP     dP  \\`88888\'
oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
',		'WARNING o8'=>'
oooo     oooo      o      oooooooooo  oooo   oooo ooooo oooo   oooo   ooooooo8
 88   88  88      888      888    888  8888o  88   888   8888o  88  o888    88
  88 888 88      8  88     888oooo88   88 888o88   888   88 888o88  888    oooo
   888 888      8oooo88    888  88o    88   8888   888   88   8888  888o    88
    8   8     o88o  o888o o888o  88o8 o88o    88  o888o o88o    88   888ooo888
',		'WARNING roman'=>'
oooo     oooo      o      oooooooooo  oooo   oooo ooooo oooo   oooo   ooooooo8
 88   88  88      888      888    888  8888o  88   888   8888o  88  o888    88
  88 888 88      8  88     888oooo88   88 888o88   888   88 888o88  888    oooo
   888 888      8oooo88    888  88o    88   8888   888   88   8888  888o    88
    8   8     o88o  o888o o888o  88o8 o88o    88  o888o o88o    88   888ooo888
',		'WARNING speed'=>'
___       _________ ________ _____   _______________   ___________
__ |     / /___    |___  __ \___  | / /____  _/___  | / /__  ____/
__ | /| / / __  /| |__  /_/ /__   |/ /  __  /  __   |/ / _  / __
__ |/ |/ /  _  ___ |_  _, _/ _  /|  /  __/ /   _  /|  /  / /_/ /
____/|__/   /_/  |_|/_/ |_|  /_/ |_/   /___/   /_/ |_/   \____/
',
		// https://lazesoftware.com/ja/tool/hugeaagen/
		'警告 IPAexゴシック'=>'
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　
　　　　　　■■■　　　　■■■　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　
　　　　　　■■■　　　　■■■　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■　　■■■　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■　　■■■■■■■■■■■■■■　　　　　　　　　　　■■■　　　　　　　■■■　　　　　　　　　　　　　　　
　　　　　　■■■　　　　■■■　　　　　　■■■■■■■■■■■■■■■　　　　　　　　　　　■■■　　　　　　　■■■　　　　　　　　　　　　　　　
　　　　■■■　　　　　　　　　　　　　　　■■■■　　　　　■■　　　　　　　　　　　　　　■■■■　　　　　　　■■■　　　　　　　　　　　　　　　
　　　　■■■■■■■■■■■■■■■■　■■■■■　　　　■■■　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　
　　　■■■■■■■■■■■■■■■■■　■■■■■■　　　■■　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　
　　■■■　　　　　　　　　　　　■■■　■■　　■■■　■■■　　　　　　　　　　　　　　■■■　　　　　　　　　■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■　　　■■■　　　　　　■■■■■　　　　　　　　　　　　　　■■■■　　　　　　　　　■■■　　　　　　　　　　　　　　　
　■■■　■■　　　　　■■　　　■■■　　　　　　■■■■■　　　　　　　　　　　　　　■■■　　　　　　　　　　■■■　　　　　　　　　　　　　　　
　　■　　■■　　　　　■■　　　■■■　　　　　■■■■■■■■　　　　　　　　　　　■■■■　　　　　　　　　　■■■　　　　　　　　　　　　　　　
　　　　　■■■■■■■■■　　　■■　　　　■■■■■　　■■■■■　　　　　　　　　　■■　　　　　　　　　　　■■■　　　　　　　　　　　　　　　
　　　　　■■■■■■■■■■■■■■　■■■■■■　　　　　■■■■■■　　　　　　　　　■　　　　　　　　　　　■■■　　　　　　　　　　　　　　　
　　　　　■■　　　　　　　■■■■　　■■■■　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　■　　　　　　　　　　　　　■　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■　　　　
', 		'警告 IPAex明朝'=>'
　　　　　　　■■　　　　■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　■■■　　　■■■　　　■　　　　■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　
　　　　　　　■■　　　　■■　　　■■■　　　■■■　　　　　　　　　　　　　　　　　　　　　　　■　　　　　　　■■■■　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■　　■■■　　　　　　　　■■　　　　　　　　　　　　　■■■■　　　　　■■　　　　　　　　　　　　　　　　
　　　　　　　■■　　　　■■　　　　　　　　■■　　　　　　　　■■■　　　　　　　　　　　　　■■■■　　　　　■■　　　　　　　　　　　　　　　　
　　　　　■■■■　　　　■■　　　　　　　■■■■■■■■■■■■■■■　　　　　　　　　　　　■■■　　　　　　■■　　　　　　　　　　　　　　　　
　　　　■■■　　　　　　　　　　■　　　　■■　　　　　　　■■■　　　　　　　　　　　　　　■■■　　　　　　　■■　　　　　　　　　　■　　　　　
　　　　■■■■■■■■■■■■■■■■　■■　■　　　　　■■■　　　　　　　　　　　　　　　■■■　　　　　　　■■　　　　　　　　　　■■　　　　
　　　■■　　　　　　　　　　　■■■　　■　　■■　　　　■■　　　　　　　　　　　　　　　　■■　　　　　　　　■■　　　　　　　　　■■■■　　　
　　　■■■　　　　　■■　　　■■■　■　　　　■■　　■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　　■■■■■■■■■■■■　　■■■　　　　　　　■■■■■　　　　　　　　　　　　　　　　■■　　　　　　　　　■■　　　　　　　　　　　　　　　　
　■■　■■　　　　　■■　　　■■■　　　　　　　■■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　■■　　　　　　　　　　　　　　　　
　■　　■■　　　　　■■　　　■■■　　　　　　　■■■■■　　　　　　　　　　　　　　　■■　　　　　　　　　　■■　　　　　　　　　　　　　　　　
　　　　■■　　　　　■■　　　■■　　　　　　■■■■　■■■■　　　　　　　　　　　　■■　　　　　　　　　　　■■　　　　　　　　　　　　　　　　
　　　　■■■■■■■■■　　　■■　　　　　■■■　　　　■■■■■　　　　　　　　　　■■　　　　　　　　　　　■■　　　　　　　　　　　　　　　　
　　　　■■　　　　　■■■■■■■　　　■■■　　　　　　　　■■■■■　　　　　　　■■　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　
　　　　　■　　　　　　　　■■■　　　■■　　　　　　　　　　　　■■　　　　　　　　■　　　　　　　　　　　　　■■　　　　　　　　　　　　■■　　
　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　■■■■　
　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　■■　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　
　　　　　　　■　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　■■　　　　　　
',		'警告 Noto Sans Japanese'=>'
　　　　　　■■　　　　　■■　　　　　　　　　■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　
　　　　　　■■■　　　　■■■　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　■■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■　　　■■■　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　■■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■　　　■■■■■■■■■■■■■■　　　　　　　　　　　■■■　　　　　　　■■■■　　　　　　　　　　　　　　　
　　　　　　■■■　　　　■■■　　　　　　■■■■■■■■■■■■■■■　　　　　　　　　　■■■■　　　　　　　■■■■　　　　　　　　　　　　　　　
　　　　■■■■　　　　　■■　　　　　　■■■■■■■■■■■■■■■■　　　　　　　　　　■■■　　　　　　　　■■■■　　　　　　　　　　　　　　　
　　　　■■■■■■■■■■■■■■　　■■■■■　　　　　　■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　　　■■■■■■■■■■■■■■■　■■■■■■■　　　　■■■　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　　■■■　　　　　　　　　　■■■■■■■　　■■■　　　■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　■■■■■　　　　　　　　　　■■　　■　　　■■■　　■■■　　　　　　　　　　　　　■■■　　　　　　　　　　■■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■　　　■■　　　　　　　■■■■■■　　　　　　　　　　　　　■■■■　　　　　　　　　　■■■■　　　　　　　　　　　　　　　
　　　■■■　　　　■■■　　■■■　　　　　　　　■■■■　　　　　　　　　　　　　■■■■　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　
　　　　■■　　　　■■■　　■■■　　　　　　■■■■■■■　　　　　　　　　　　■■■■　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　
　　　■■■■■■■■■■　　■■■　　　　■■■■■　■■■■■■　　　　　　　　　■■　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　
　　　■■■■■■■■■■■■■■■　■■■■■■■　　　　■■■■■■■　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　
　　　　　　　　　　　　■■■■■　　　■■■　　　　　　　　　■■■■■　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　
',			'警告 Noto Serif Japanese'=>'
　　　　　　■■　　　　　■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■　　　　　　　　　　　　　　　　　　　
　　　　　　■■■　　　■■■■　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　　　■■　　　　■■■　　　■■　　　　■■■　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　■■　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■　　■■■　　　　　　　■■　　　　　　　　　　　　　■■■　　　　　　　■■　　　　　　　　　　　　　　　　　　
　　　　　■■■■　　　■■■　　　　　　　　■■■　　　　　■■■■■　　　　　　　　　　　　■■■　　　　　　　■■　　　　　　　　　　　　　　　　　　
　　　　　■■■　　　　　■　　　　　　　　■■■■■■■■■■■■■■■　　　　　　　　　　　■■■　　　　　　　■■　　　　　　　　　　■　　　　　　　
　　　　　■■■　　　　　　　　　■　　　　■■■　　　　　■■■　　　　　　　　　　　　　　■■■　　　　　　　　■■　　　　　　　　　■■■■　　　　　
　　　　■■■■■■■■■■■■■■■■　■■■■　　　　　■■■　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
　　　　■■　　　　　　　　　　■■■　　■■　■■　　　■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　■■■　　　　　■　　　　■■■　■■　　　■■　■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　■■　　　　　　　　　　　　　　　　　　
　　■■■■■■■■■■■　　　■■■■■　　　　　■■■■　　　　　　　　　　　　　　　　■■　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　
　■■　■■■　　　■■■　　　■■　　　　　　　　■■■■　　　　　　　　　　　　　　　■■　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　
　　　　■■　　　　■■■　　　■■　　　　　　　■■■■■■　　　　　　　　　　　　　　■　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　
　　　　■■■■■■■■■　　　■■　　　　　　■■■　　■■■■■　　　　　　　　　　■■　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　
　　　　■■■■■■■■■■■■■■　　　　■■■　　　　　■■■■■■■　　　　　　　■　　　　　　　　　　　　　■■　　　　　　　　　　　　　■■　　　
　　　　■■　　　　■■　　■■■　　■■■　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　■■■■　　
　　　　■　　　　　　　　　　■　　　　　　　　　　■■　　　　　　■■　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■　　　　■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　
　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　　
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　■　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　■■　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　
　　　　　　　　■■　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■　　　　　　　　
',		'警告 BIZ UDゴシック'=>'
　　　　　　　■■　　　　　■■■　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　　　■■■■　　　　■■■　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　　　　■　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　■■■　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　　　　■■　　　　　■■■　　　　　　　■■■■■■■■■■■■■■　　　　　　　　　　■■■■　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　　■■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■　　　　　　　　　　■■■　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　■■■■　　　　　　　　　　　　　　　■■■■　　　　　■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
　　　■■■■■■■■■■■■■■■■■■　■■■■■■　　　　■■■　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　　■■■■■■■■■■■■■■■■■■■　■■■　■■■　　■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　■■■■■　　　　　　　　　　　　■■■　　■　　　■■■　■■■　　　　　　　　　　　■■■■　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　■■■　■■■■■■■■■■■　　■■■　　　　　　■■■■■■　　　　　　　　　　　■■■■　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　■　　■■■■■■■■■■■　　■■■　　　　　　　■■■■■　　　　　　　　　　■■■■　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　　■■■　　　　　■■■　　■■■　　　　　■■■■■■■■■　　　　　　　　■■■　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　　■■■■■■■■■■■　　■■■　　■■■■■■■　■■■■■■　　　　　　　　■　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　　■■■■■■■■■■■■■■■　■■■■■■■　　　　　■■■■■■　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　■■■■■　　　■■■■　　　　　　　　　■■■　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　■■■■　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　■■■■　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
　　　　　■■■■　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　
',			'警告 BIZ UD明朝'=>'
　　　　　　■■■　　　　■■■　　　　　　　　■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　■■■　　　　■■■　　■■　　　　■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■　　　■■　　　　　　　　■■　　　　　　　　　　　　　■■■■　　　　　■■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■　　■■■■■■■■■■■■■■　　　　　　　　　　　　■■■■　　　　　■■　　　　　　　　　　　　　　　　　
　　　　■■■■■　　　　■■　　　　　　　　■■■■■■■■■■■■■■　　　　　　　　　　　■■■■　　　　　　■■　　　　　　　　　　　　　　　　　
　　　　■■■　　　　　　　　　　■　　　　■■■■　　　　　■■■　　　　　　　　　　　　　　■■■　　　　　　　■■　　　　　　　　　　　　　　　　　
　　　■■■■■■■■■■■■■■■■■　■■■■■　　　　　■■　　　　　　　　　　　　　　　■■■　　　　　　　■■　　　　　　　　　　■　　　　　　
　　　■■■■■■■■■■■■■■■■■　■■　　■■　　　■■■　　　　　　　　　　　　　　■■■　　　　　　　　■■　　　　　　　　　■■■　　　　　
　　■■■　　　　　　　　　　　　■■　■■　　　■■■　■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
　■■　■■■■■■■■■　　　　■■　　　　　　　■■■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　
■■　　■■■■■■■■■■　　　■■　　　　　　　　■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　■■　　　　　　　　　　　　　　　　　
　　　　■■　　　　　■■　　　　■■　　　　　　　■■■■■■　　　　　　　　　　　　　■■■　　　　　　　　　　■■　　　　　　　　　　　　　　　　　
　　　　■■■■■■■■■　　　■■■　　　　　■■■■　■■■■■　　　　　　　　　　　■■　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　
　　　　■■■■■■■■■　　　■■■　　　■■■■　　　　　■■■■■■　　　　　　　■■　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　
　　　　■■　　　　　　　■■■■■　　■■■■　　　　　　　　　■■■■　　　　　　■■■　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　
　　　　■■　　　　　　　　　■■　　　■　　　　　　■■　　　　　　■　　　　　　　　■　　　　　　　　　　　　　■■　　　　　　　　　　　　　■　　　
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　■■■　　
　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■　　　　　　　　　　　　　　　　　　　　　　　■　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　
　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
　　　　　　■■　　　　　　　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　■■■　　　　　　
',			'警告 JK丸ゴシック'=>'
　　　　　■■　　　　　　■　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　　　　■■■　　　　■■■　　　　　　■■■■　　　　　　　　　　　　　　　　　　　　　　■■　　　　　　　　■■■　　　　　　　　　　　　　　　　
　　■■■■■■■■■■■■■■■■　　　■■■■　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　■■■■■　　　　　　　　　　　　　　　
■■■■■■■■■■■■■■■■■■■　■■■■■■■■■■■■■■■　　　　　　　　　　　■■■■　　　　　　■■■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■　　■■■■■■■■■■■■■■■■　　　　　　　　　■■■■■　　　　　　■■■■■　　　　　　　　　　　　　　　
　　　　■■■■　　　　■■■　　　　■■■■■■■■■■■■■■■■　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　　　■■■■■　　　■■■■■　　■■■■　　　　　　　■■■■　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　　■■■■■■■■■■■■■■■■■■■■■■　　　　■■■■　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　
　　■■■■■■■■■■■■■■■■■■■■■■■　　　■■■■　　　　　　　　　　　■■■■■　　　　　　　　■■■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■　　■■■■■■　　■■■■■■■■■　　　　　　　　　　　■■■■■　　　　　　　　　■■■■■　　　　　　　　　　　　　　　
　■■■■■■■■■■■■　■■■■　　　　　■■■■■■■　　　　　　　　　　　　■■■■■　　　　　　　　　■■■■■　　　　　　　　　　　　　　　
　■■■■■　　　　■■■　■■■■　　　　■■■■■■■■　　　　　　　　　　　　■■■■　　　　　　　　　　■■■■■　　　　　　　　　　　　　　　
　■■■■■　　　　■■■■■■■■　　■■■■■■■■■■■■　　　　　　　　　　■■■　　　　　　　　　　　■■■■■　　　　　　　　　　　　　　　
　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　■■■■■　　　　　　　　　　　　　　　
　　　■■■■■■■■■■■■■■　■■■■■■　　　　■■■■■■■　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　
　　　■■■　　　　　■■■■■　　　■■　　　　　　　　　　■■■■　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
　■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　■■■■■　　　　　　　　　　　　　　　　　　■■■■■　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　■■■■■　　　　　　　　　　　　　　　　　　■■■■■　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　
　　　　■■■■■■■■■■■■■■■■■■■■■■■■■■■■　　　　　　　　　　　　　■■■■　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　■■■■■　　　　　　　　　　　　　　　　　　■■■■■　　　　　　　　　　　　　■■■　　　　　　　　　　　　　　　　　　　■■■■　　　　　
　　　　　　■　　　　　　　　　　　　　　　　　　　　　　■　　　　　　'
		];
