######################################################################
# @@HEADER2_NANAMI@@
######################################################################

package	Nana::OAuth;
use 5.005;
use strict;
use integer;
use Exporter;
use vars qw($VERSION);
use LWP::UserAgent;
use CGI;
use Nana::Login;

$Nana::OAuth::List={
	twitter=>{
		name=>$::resource{login_plugin_oauth_service_twitter},
		ConsumerKey=>$login::oauth{twitter}{ConsumerKey},
		ConsumerSecret=>$login::oauth{twitter}{ConsumerSecret},
		request_token_url=>"https://api.twitter.com/oauth/request_token",
		authorize_url=>"https://api.twitter.com/oauth/request_token",
		access_token_url=>"https://api.twitter.com/oauth/access_token",
		request_method=>"GET",
		verify_request_method=>"POST",
		signature_method=>'HMAC-SHA1',
		alt=>"Login for twitter",
		lang=>"ja",
		logo_small=>"btn_twitter_small",
		small=>"logo1",
		big=>"logo1",
	},
};

my $request_token;
my $request_token_secret;

sub list {
	my @r;
	foreach(keys %{$Nana::OAuth::List}) {
		push(@r, $_) if($_!~/^\_/);
	}
	@r;
}

sub getid {
	my($id,$size)=@_;

	my $imgid;
	my $url=$Nana::OAuth::List->{$id}->{url};
	my $name=$Nana::OAuth::List->{$id}->{name};
	my $plusid=$Nana::OAuth::List->{$id}->{plusid}+0;
	if($size eq "big") {
		$imgid=$Nana::OAuth::List->{$id}->{logo_big};
	}
	$imgid=$Nana::OAuth::List->{$id}->{logo_small};
	return($url, $id, $name, $imgid, $plusid);
}

# my $CLAIMED_URL = $cgi->param('OAuth');

# http://m2m.mino.net/OAuth-sample.cgi
sub login {
	my ($url, $addquery, $id)=@_;

	my $request = Net::OAuth->request("request token")->new(
				consumer_key	=> $Nana::OAuth::List->{$id}->{ConsumerKey},
				consumer_secret	=> $Nana::OAuth::List->{$id}->{ConsumerSecret},
				request_url		=> $Nana::OAuth::List->{$id}->{request_url},
				request_method	=> $Nana::OAuth::List->{$id}->{request_method},
				signature_method=> $Nana::OAuth::List->{$id}->{signature_method},
				timestamp		=> time,
				nonce			=> int(rand(2**31 - 999999 + 1)) + 999999,
				callback		=> $url . ($addquery eq "" ? "" : "&amp;$addquery"),
	);

	$request->sign;

	my $ua = LWP::UserAgent->new(
		agent =>"$::package/$::version OAuth.pm",
		keep_alive => 1,
		timeout => 10
	);
	my $http_hdr = HTTP::Headers->new(
		'Authorization' => $request->to_authorization_header
	);
	my $http_req = HTTP::Request->new(
		$Nana::OAuth::List->{$id}->{request_method},
		$Nana::OAuth::List->{$id}->{request_url},
		$http_hdr
	);
	my $res = $ua->request($http_req);
	if ($res->is_success) {
		my $response = Net::OAuth->response('request token')->from_post_body($res->content);
		if (defined $response->token) {
			$request_token = $response->token;
			$request_token_secret = $response->token_secret;
		}
	} else {
		return $res->status_line;
	}
	return $Nana::OAuth::List->{$id}->{authorize_url} . "?oauth_token=".$request_token."\n\n";
}

sub verify {
	my ($id)=@_;
	my $request_method = 'POST';
	my $request = Net::OAuth->request("access token")->new(
				consumer_key	=> $Nana::OAuth::List->{$id}->{ConsumerKey},
				consumer_secret	=> $Nana::OAuth::List->{$id}->{ConsumerSecret},
				request_url		=> $Nana::OAuth::List->{$id}->{access_token_url},
				request_method	=> $Nana::OAuth::List->{$id}->{verify_request_method},
				signature_method=> $Nana::OAuth::List->{$id}->{signature_method},
				timestamp		=> time,
				nonce			=> int(rand(2**31 - 999999 + 1)) + 999999,
				callback		=> '',
				token			=> $::form{oauth_token},
				verifier		=> $::form{oauth_verifier},
				token_secret	=> '',
	);
	$request->sign;
	my $ua = LWP::UserAgent->new(
		agent =>"$::package/$::version OAuth.pm",
		keep_alive => 1,
		timeout => 10
	);
	my $http_hdr = HTTP::Headers->new(
		'User-Agent' => "$::package/$::version OAuth.pm"
	);
	my $http_req = HTTP::Request->new(
		$Nana::OAuth::List->{$id}->{verify_request_method},
		$Nana::OAuth::List->{$id}->{access_token_url},
		$http_hdr,
		$request->to_post_body
	);
	my $res = $ua->request($http_req);

	if ($res->is_success) {
		my $response = Net::OAuth->response('access token')->from_post_body($res->content);
		return(
			status=>"login",
			access_token=>$response->token,
			access_token_secret=>$response->token_secret,
		);
	} else {
		return(status=>"cancel");
	}
}

1;
