######################################################################
# @@HEADER2_NANAMI@@
######################################################################
# v0.2.1 First Release
######################################################################

use strict;
use Nana::Enc;

# captchatɂȂ܂ł̉
$login::captchaon=5;

# [F؂̗L
$login::confirmexpire=24 * 60 * 60;

# ZbV̗L
$login::sessionexpire=180 * 24 * 60 * 60;

# pX[h̗L
$login::passexpire=30 * 24 * 60 * 60;

# OCtH[
$login::loginforms1="text|id,password|password,select|expire|login_plugin_login_expire,submit|submit|login_plugin_login_button";
# captchatOCtH[
$login::loginforms2="text|id,password|password,captcha|captcha,select|expire|login_plugin_login_expire,submit|submit|login_plugin_login_button";

# readuser writeuser readwrite
$login::useraddpolicy="writeuser";

# none, days, admin
$login::useraddpolicy2="days";

$login::writewaitdays=7;

$login::formexpire=24*60*60;


$login::imeon="ime-mode: active;";
$login::imeoff="ime-mode: disabled;";

# cookie
$login::cookie_confirm=$::login_confirm_cookie;
$login::cookie_session=$::login_session_cookie;

$login::style={
	nickname=>{
		style=>$login::imeon,
		size=>"250,15",
		length=>"2,32",
		check=>\&plugin_login_check_userid,
		onfocus=>"j_nickname",
		onblur=>"j_nickname",
		onchange=>"j_nickname",
		onkeypres=>"j_nickname",
		onsubmit=>"j_nickname",
	},
	id=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"4,16",
		check=>\&plugin_login_check_userid,
		onfocus=>"j_form",
		onblur=>"j_form",
#		onsubmit=>"j_nickname",
	},
	userid=>{
		style=>$login::imeoff,
		size=>"250,15",
		length=>"4,16",
		check=>\&plugin_login_check_userid,
		onfocus=>"j_userid",
		onblur=>"j_userid",
		onsubmit=>"j_nickname",
	},
	password=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"6,32",
		check=>\&plugin_login_check_password,
		onfocus=>"j_form",
		onblur=>"j_form",
	},
	pass1=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"6,32",
		check=>\&plugin_login_check_newpass,
		objs=>"pass1,pass2",
		onkeyup=>"j_newpass",
		onfocus=>"j_newpass",
		onblur=>"j_newpass",
		onsubmit=>"j_newpass",
	},
	pass2=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"6,32",
		check=>\&plugin_login_check_newpass,
		objs=>"pass1,pass2",
		onkeyup=>"j_newpass",
		onfocus=>"j_newpass",
		onblur=>"j_newpass",
		onsubmit=>"j_newpass",
	},
	email=>{
		style=>$login::imeoff,
		size=>"250,15",
		length=>"8,256",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	emailchk=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"8,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	emailchk1=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"3,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	emailchk2=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"8,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	confirm=>{
		style=>$login::imeoff,
		size=>"400,15",
		length=>"30,255",
#		check=>\&plugin_login_check_confirm,
	},
	femail=>{
		style=>$login::imeoff,
		size=>"250,15",
		length=>"8,256",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	femailchk=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"8,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	femailchk1=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"3,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	femailchk2=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"8,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	expire=>{
		size=>"150,20",
	},
	submit=>{
		size=>"150,20",
	},
};

#$::login_enq_form="enq";
#$::login_enq_form_cols=50;

sub login_read_resource {
	my ($file, %r)=@_;

	if(-r "$::res_dir/$file.$::lang.txt") {
		%r=&read_resource("$::res_dir/$file.$::lang.txt", %r);
	} elsif(-r "$::res_dir/$file.txt") {
		%r=&read_resource("$::res_dir/$file.txt", %r);
	}
	%r;
}

sub plugin_login_submitbutton {
	my($name, $formid, $pform, $value)=@_;
	my $body;
	my $js;
	if(&iscryptpass) {
		$js.="return lsubmit(a,\'$name\',\'$pform\');"
	}
	$body=qq(<input type="submit" name="$formid" value="$value" />)
		if($formid ne $value);
	return($body, $js);
}


sub plugin_login_action {
	my $body;
	my $login_plugin_title=$::resource{login_plugin_login};

	&jscss_include("passwd");
	my $mode=$::form{mode};
	if($::useExPlugin eq 1 && $::_exec_plugined{login} eq 2) {
		if($mode eq "logout") {
			return &plugin_login_logout;
		} elsif($mode eq "") {
			return &plugin_login_login;
		} elsif($mode eq "login" || $mode eq "loginonly") {
			return &plugin_login_loginonly;
		} elsif($mode eq "mypage") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_mypage;
		} elsif($mode eq "useradd") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_useradd;
		} elsif($mode eq "openid") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_openid;
		} elsif($mode eq "oauth") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_oauth;
		} elsif($mode eq "forget") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_forget;
		} elsif($mode eq "pass") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_pass;
		} elsif($mode eq "mail") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_mail;
		} elsif($mode eq "confirm") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_confirm;
		} elsif($mode eq "unregist") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_unregist;
		} elsif($mode eq "regist") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_regist;
		} elsif($mode eq "teamofuse") {
			require "$::plugin_dir/loginsub.inc.pl";
			return &plugin_login_teamofuse;
		}
	}
	return ('msg'=>"\tError", 'body'=>qq(<span class="error">login.inc.pl error</span>));
}

sub form_generate {
	my($flg)=@_;
	my $body;
	my $token_form=lf("token");
	my $expire_form=lf("generate");

	$body.=<<EOM if($::form{refer} ne "");
<input type="hidden" name="refer" value="$::form{refer}" />
EOM
	if($flg+0) {
		my $token=$::form{$token_form};
		my $expire=$::form{$expire_form};
		if(Nana::Enc::decode("", $expire, $token) +0 < time + $login::formexpire) {
			return "-";
		}
	}
	&maketoken;
	my $token=$::Token;
	my $expire=Nana::Enc::encode(time, $token);
	return <<EOM;
$body<input type="hidden" name="$token_form" value="$token" />
<input type="hidden" name="$expire_form" value="$expire" />
EOM
}

sub plugin_login_login {
	my $body;

	%::resource=&login_read_resource("login_useradd", %::resource);

	$body.=&loginhtml("login", "$login::loginforms1", "", &plugin_login_openidform);
	$body.=&loginhtml("useradd", "$login::useraddforms");
	$body.=&loginhtml("forget", "$login::forgetforms");
	return(msg=>"\t$::resource{login_plugin_title_msg}", body=>$body);
}

sub plugin_login_logout {
	my %scookie;
	&setcookie($login::cookie_session, -1 , %scookie);
	my $url="$::script?$::form{refer}";
	&location($url, 302, $::HTTP_HEADER);
}

sub plugin_login_loginonly {
	my $body;

	my $userid=$::form{lf("id")};
	if($::form{mode} eq "login") {
		my $stat=&logindo($userid
			, $::form{lf("password")}
			, $::form{lf("password") . "_enc"}
			, $::form{lf("password") . "_token"}
		);

		my $err=$::resource{"login_plugin_login_err_$stat"};
		if($err ne "") {
			$body.=<<EOM;
<span class="error">$err</span>
EOM
		} elsif($stat ne "") {
			my %tmpuser=&readuser($stat);
			my $session=$tmpuser{session};
			my $sessionpass;
			foreach(keys %::session) {
				$sessionpass=&rnd($sessionpass . $::session{$_});
			}
			$::session{sessionpass}=$sessionpass;
			my %scookie;
			$scookie{&ln("session")}=$session;
			$scookie{&ln("sessionpass")}=$sessionpass;
			&setcookie($login::cookie_session, $login::sessionexpire , %scookie);
			my $url="$::script?$::form{refer}";
			&location($url, 302, $::HTTP_HEADER);
		}
	}
	$body.=&loginhtml("login", "$login::loginforms1", "", &plugin_login_openidform);
	return(msg=>"\t$::resource{login_plugin_title_msg}", body=>$body);
}

# HTML

my $plugin_login_jsadd=0;

sub loginhtml {
	my ($title, $forms, $status, $add, %err)=@_;
	my $body;
	my $bodytmp;
	my $jsform;
	my %jsform;
	foreach(split(/,/,$forms)) {
		my($fmode, $form, $res)=split(/\|/,$_);
		my ($tmp, %fjs)=&loginform($fmode, $title, $form, $res, %err);
		$bodytmp.=$tmp;
		foreach(keys %fjs) {
			$jsform{$_}.=$fjs{$_}
				if(!/^_/);
		}
		foreach(keys %fjs) {
			if(/^_/) {
				s/^_//g;
				$jsform{$_}.=$fjs{$_}
			}
		}
	}
	foreach(keys %jsform) {
		$jsform.=qq( $_=");
		$jsform.=qq(var a=true,b;);
		$jsform.=qq($jsform{$_});
		$jsform.="return a;";
		$jsform.=qq(");
	}

	$body=<<EOM if($status ne "");
<span class="error">$status</span>
EOM
	$body.=<<EOM;
<h3>$::resource{"login_plugin\_$title\_title"}</h3>
<form action="$::script" method="post" id="$title" name="$title"$jsform>
@{[&form_generate]}
<input type="hidden" name="cmd" value="login" />
<input type="hidden" name="mode" value="$title" />
<table>
$bodytmp
EOM

	my $msg=$::resource{"login_plugin\_$title\_msg"};
	$msg.=$::resource{"login_plugin\_$title\_msg\_$login::useraddpolicy"};

	$msg=&replace($msg,
		MAIL=>$::form{lf("email")},
		TITLE=>$::wiki_title,
		script=>$::script,
		DAYS=>$login::writewaitdays,
		login_plugin_useradd_msg=>$::resource{"login_plugin\_$title\_msg\_$login::useraddpolicy2"}
	);
	$body.=<<EOM;
<tr><td>&nbsp;</td><td colspan="2">$msg</td></tr>
EOM
	$body.=<<EOM if($add ne "");
<tr><td>&nbsp;</td><td>$add</td></tr>
EOM

	$body.=<<EOM;
</table>
</form>
EOM
	$body;
}


1;
