######################################################################
# @@HEADER2_NANAMI@@
######################################################################
# v0.2.1 First Release
######################################################################

use strict;
use Nana::Enc;
use Nana::OpenID;

# captchatɂȂ܂ł̉
$login::captchaon=5;

# [F؂̗L
$login::confirmexpire=24 * 60 * 60;

# ZbV̗L
$login::sessionexpire=180 * 24 * 60 * 60;

# pX[h̗L
$login::passexpire=30 * 24 * 60 * 60;

# OCtH[
$login::loginforms1="text|id,password|password,select|expire|login_plugin_login_expire,submit|submit|login_plugin_login_button";
# captchatOCtH[
$login::loginforms2="text|id,password|password,captcha|captcha,select|expire|login_plugin_login_expire,submit|submit|login_plugin_login_button";

# readuser writeuser readwrite
$login::useraddpolicy="writeuser";

# none, days, admin
$login::useraddpolicy2="days";

$login::writewaitdays=7;

$login::formexpire=24*60*60;

# [U[o^ptH[
$login::useraddforms="text|userid,password|pass1,password|pass2,mail|email,mailconfirm|emailchk,captcha|captcha,submit2|submit|login_plugin_useradd_button"
	if(!defined($login::useraddforms));
$login::useraddforms="text|nickname,select|sex|login_plugin_useradd_sex_value,date|birthday,text|userid,password|pass1,password|pass2,mail|email,mailconfirm|emailchk,captcha|captcha,submit2|submit|login_plugin_useradd_button";

# confirmtH[
$login::confirmforms="text|confirm,submit|submit|login_plugin_confirm_button";

# pX[hĔstH[
$login::forgetforms="text|femail,mailconfirm|femailchk,date|birthday,captcha|fcaptcha,submit|submit|login_plugin_forget_button";

$login::imeon="ime-mode: active;";
$login::imeoff="ime-mode: disabled;";

# cookie
$login::cookie_confirm=$::login_confirm_cookie;
$login::cookie_session=$::login_session_cookie;

$login::style={
	nickname=>{
		style=>$login::imeon,
		size=>"250,15",
		length=>"2,32",
		check=>\&plugin_login_check_userid,
		onfocus=>"j_nickname",
		onblur=>"j_nickname",
		onchange=>"j_nickname",
		onkeypres=>"j_nickname",
		onsubmit=>"j_nickname",
	},
	id=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"4,16",
		check=>\&plugin_login_check_userid,
		onfocus=>"j_form",
		onblur=>"j_form",
#		onsubmit=>"j_nickname",
	},
	userid=>{
		style=>$login::imeoff,
		size=>"250,15",
		length=>"4,16",
		check=>\&plugin_login_check_userid,
		onfocus=>"j_userid",
		onblur=>"j_userid",
		onsubmit=>"j_nickname",
	},
	password=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"6,32",
		check=>\&plugin_login_check_password,
		onfocus=>"j_form",
		onblur=>"j_form",
	},
	pass1=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"6,32",
		check=>\&plugin_login_check_newpass,
		objs=>"pass1,pass2",
		onkeyup=>"j_newpass",
		onfocus=>"j_newpass",
		onblur=>"j_newpass",
		onsubmit=>"j_newpass",
	},
	pass2=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"6,32",
		check=>\&plugin_login_check_newpass,
		objs=>"pass1,pass2",
		onkeyup=>"j_newpass",
		onfocus=>"j_newpass",
		onblur=>"j_newpass",
		onsubmit=>"j_newpass",
	},
	email=>{
		style=>$login::imeoff,
		size=>"250,15",
		length=>"8,256",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	emailchk=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"8,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	emailchk1=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"3,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	emailchk2=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"8,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	confirm=>{
		style=>$login::imeoff,
		size=>"400,15",
		length=>"30,255",
#		check=>\&plugin_login_check_confirm,
	},
	femail=>{
		style=>$login::imeoff,
		size=>"250,15",
		length=>"8,256",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	femailchk=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"8,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	femailchk1=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"3,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	femailchk2=>{
		style=>$login::imeoff,
		size=>"100,15",
		length=>"8,256",
		errform=>"emailchk",
		check=>\&plugin_login_check_email,
		objs=>"email,emailchk1,emailchk2",
		onfocus=>"j_email",
		onblur=>"j_email",
	},
	expire=>{
		size=>"150,20",
	},
	submit=>{
		size=>"150,20",
	},
};

#$::login_enq_form="enq";
#$::login_enq_form_cols=50;

sub login_read_resource {
	my ($file, %r)=@_;

	if(-r "$::res_dir/$file.$::lang.txt") {
		%r=&read_resource("$::res_dir/$file.$::lang.txt", %r);
	} elsif(-r "$::res_dir/$file.txt") {
		%r=&read_resource("$::res_dir/$file.txt", %r);
	}
	%r;
}

sub plugin_login_submitbutton {
	my($name, $formid, $pform, $value)=@_;
	my $body;
	my $js;
	if(&iscryptpass) {
		$js.="return lsubmit(a,\'$name\',\'$pform\');"
	}
	$body=qq(<input type="submit" name="$formid" value="$value" />)
		if($formid ne $value);
	return($body, $js);
}


sub plugin_login_action {
	my $body;
	my $login_plugin_title=$::resource{login_plugin_login};

	&jscss_include("passwd");
	my $mode=$::form{mode};
	if($::useExPlugin eq 1 && $::_exec_plugined{login} eq 2) {
		if($mode eq "logout") {
			return &plugin_login_logout;
		} elsif($mode eq "") {
			return &plugin_login_login;
		} elsif($mode eq "login" || $mode eq "loginonly") {
			return &plugin_login_loginonly;
		} elsif($mode eq "mypage") {
			return &plugin_login_mypage;
		} elsif($mode eq "useradd") {
			return &plugin_login_useradd;
		} elsif($mode eq "openid") {
			return &plugin_login_openid;
		} elsif($mode eq "forget") {
			return &plugin_login_forget;
		} elsif($mode eq "pass") {
			return &plugin_login_pass;
		} elsif($mode eq "mail") {
			return &plugin_login_mail;
		} elsif($mode eq "confirm") {
			return &plugin_login_confirm;
		} elsif($mode eq "unregist") {
			return &plugin_login_unregist;
		} elsif($mode eq "regist") {
			return &plugin_login_regist;
		} elsif($mode eq "teamofuse") {
			return &plugin_login_teamofuse;
		}
	}
	return ('msg'=>"\tError", 'body'=>qq(<span class="error">login.inc.pl error</span>));
}

sub plugin_login_teamofuse {
	my $body;

	%::resource=&login_read_resource("login_teamofuse", %::resource);
	$::nowikiname = 1;
	&init_inline_regex;
	my $body=&replace($::resource{login_teamofuse_msg},
		TITLE=>$::wiki_title,
		script=>$::script,
		DAYS=>$login::writewaitdays,
	);

	return(msg=>"\t$::resource{login_teamofuse_title}", body=>&text_to_html($body));
}

sub form_generate {
	my($flg)=@_;
	my $body;
	my $token_form=lf("token");
	my $expire_form=lf("generate");

	$body.=<<EOM if($::form{refer} ne "");
<input type="hidden" name="refer" value="$::form{refer}" />
EOM
	if($flg+0) {
		my $token=$::form{$token_form};
		my $expire=$::form{$expire_form};
		if(Nana::Enc::decode("", $expire, $token) +0 < time + $login::formexpire) {
			return "-";
		}
	}
	&maketoken;
	my $token=$::Token;
	my $expire=Nana::Enc::encode(time, $token);
	return <<EOM;
$body<input type="hidden" name="$token_form" value="$token" />
<input type="hidden" name="$expire_form" value="$expire" />
EOM
}

sub chksubmit {
	my ($form)=@_;
	return 1 if($::form{lf($form)} ne "");
	return 1 if($::form{"_" . lf($form)} ne "");
	return 0;
}

sub login_adduser {
	my $body;
	my %err;
	$err{ok}=1;
	my %v;
	foreach(split(/,/,$login::useraddforms)) {
		my($mode, $form, $dmy)=split(/\|/,$_);
		my $chkmethod=undef;
		if($form eq "emailchk" || $form eq "captcha" || $form eq "submit") {
			next;
		}
		if(defined($login::style->{$form}->{check})) {
			$chkmethod=$login::style->{$form}->{check};
		}
		if($chkmethod ne undef) {
			if($mode eq "text" || $mode eq "mail") {
				%err=&$chkmethod($form, $::form{lf($form)}, %err);
				$err{ok}=0 if($err{$form} ne "");
			}
		}
	}
	if($err{ok}) {
		foreach(split(/,/,$login::useraddforms)) {
			my($mode, $form, $dmy)=split(/\|/,$_);
			if($form eq "emailchk" || $form eq "captcha" || $form eq "submit") {
				next;
			} elsif($mode eq "text") {
				$v{$form}=$::form{lf($form)};
			} elsif($mode eq "select") {
				$v{$form}=$::form{lf($form)};
			} elsif($mode eq "date") {
				$v{$form}=
					$::form{lf($form . "y")} . "/"
				.	$::form{lf($form . "m")} . "/"
				.	$::form{lf($form . "d")};
			} elsif($mode eq "password") {
				$v{$form}=&password_decode($::form{lf($form)}, $::form{lf($form) . "_enc"}, $::form{lf($form) . "_token"});
				$v{$form}=~s/\t.*//g;
				&load_module("Nana::Crypt");
				$v{$form}=Nana::Crypt::encode($v{$form});
			} elsif($mode eq "mail") {
				$v{$form}=$::form{lf($form)};
			}
		}
		&createuser($v{userid});
		&createuser($v{email});
		my $session=&makesession;
		$::user{session}=$session;
		$::user{userid}=$v{userid};
		$::user{email}=$v{email};
		&writeuser($v{userid}, %::user);
		$::user{session}=$session;
		$::user{userid}=$v{userid};
		$::user{email}=$v{email};
		&writeuser($v{email}, %::user);

		$::session{session}=$session;
		foreach(keys %v) {
			$::session{$_}=$v{$_};
		}

		$::session{password}=$::session{pass1};
		delete $::session{pass1};
		delete $::session{pass2};

		&createsession($session);
		my $confirm;
		do {
			foreach(keys %::session) {
				$confirm=&rnd($confirm . $::session{$_});
			}
		} while(&searchsession("confirm", $confirm) ne undef);

		my $sessionpass=$confirm;
		foreach(keys %::session) {
			$sessionpass=&rnd($sessionpass . $::session{$_});
		}
		$::session{confirmexpire}=time + $login::confirmexpire;
		$::session{passexpire}=time + $login::passexpire;
		$::session{confirm}=$confirm;
		$::session{sessionpass}=$sessionpass;
		my %scookie;
		$scookie{p}=$sessionpass;
		&setcookie($login::cookie_confirm, $login::confirmexpire , %scookie);
		$::session{confirm}=$confirm;
		$login::value::email=$v{email};
		%login::value::session=%::session;

		&writesession($session, %::session);
		&plugin_login_confirm_mail;
		$body.=&plugin_login_confirm;
	}
	return (msg=>"\t$::resource{login_plugin_title_msg}", body=>$body);
}

sub plugin_login_confirm_mail {
	&mail("confirmmail", $login::value::email, %::login::value::session);
}

sub plugin_login_confirm {
	my $title;
	my $body;
	my %err;

	%::resource=&login_read_resource("login_useradd", %::resource);
	$err{ok}=0;
	if($::form{x} eq "") {
		$::form{x}=$::form{lf("confirm")};
	}
	if($::form{x} ne "") {
		my $s=&searchsession("confirm", $::form{x});
		if($s ne undef) {
			&readsession($s);
			my %cook;
			%cook=getcookie($login::cookie_confirm, %cook);
			if($::session{sessionpass} eq $cook{p}) {
				if($::session{confirmexpire} < time) {
#					delete $::session{confirm};
#					delete $::session{sessionpass};
					&deleteuser($::session{userid});
					&deleteuser($::session{email});
					&deletesession($::session{session})
;
					$body.=qq(<span class="error">$::resource{login_plugin_confirm_expire}</span>);
					$body.=&loginhtml("useradd", "$login::useraddforms","","",%err);

					return (msg=>"\t$::resource{login_plugin_title_msg}", body=>$body);
				} else {
					&setcookie($login::cookie_confirm, -1, %cook);
					$::session{confirm}="";
					$::session{confirmexpire}="";
					$::session{sessionpass}="";
					&writesession($s, %::session);
					&location("?cmd=login&amp;mode=loginonly", 302, $::HTTP_HEADER);
					exit;
				}
			} else {
				$body.=qq(<span class="error">$::resource{login_plugin_confirm_cookieerror}</span>);
			}
		}
		if($body eq "") {
			$body.=qq(<span class="error">$::resource{login_plugin_confirm_error}</span>);
		}
	}
	$body.=&loginhtml("confirm", "$login::confirmforms","","",%err);

	return (msg=>"\t$::resource{login_plugin_title_msg}", body=>$body);
}

sub mail {
	my($res, $to, %s)=@_;
	my %hash;
	$hash{wiki_title}=$::wiki_title;
	$hash{modifier_mail}=$::modifier_mail;
	my($url, $dmy, $dmy)=&getbasehref;
	$hash{url}=$::basehref;
	$hash{modifier_name}=$::modifier;
	$hash{DATETIME}=&date($::now_format, time);
	$hash{EXPIREDATETIME}=&date($::now_format, time + $login::confirmexpire);
	foreach(keys %s) {
		$hash{$_}=$s{$_};
	}
	foreach(keys %ENV) {
		$hash{$_}=$ENV{$_};
	}
	$hash{expire}=int($login::confirmexpire / 3600);

	%::resource=&login_read_resource("login_mail", %::resource);
	my $mail=$::resource{"login_mail_" . $res};
	$mail=&replace($mail, %hash);
	my $body;
	my $subject;
	my $from_name;
	my $to_name;
	foreach(split(/\n/, $mail)) {
		if(/^Subject:(.*)/ && $subject eq "") {
			$subject=&trim($1);
		} elsif(/^From:(.*)/ && $from_name eq "") {
			$from_name=&trim($1);
		} elsif(/^To:(.*)/ && $to_name eq "") {
			$to_name=&trim($1);
		} else {
			$body.="$_\n";
		}
	}
	&load_module("Nana::Mail");
	Nana::Mail::send(
		to=>$to,
		to_name=>$to_name,
		from=>$::modifier_mail,
		from_name=>$from_name,
		subject=>$subject,
		pgp=>0,
		data=>$body
	);
}

sub plugin_login_useradd {
	my $title;
	my $body;
	my %err;

	%::resource=&login_read_resource("login_useradd", %::resource);
	$err{ok}=1;
	if(&chksubmit("back")) {
		$err{ok}=0;
	} elsif(&chksubmit("submit2")) {
		%err=&loginchk("useradd", "$login::useraddforms","","",%err);
		return &login_adduser;
	} elsif(&chksubmit("submit")) {

		%err=&loginchk("useradd", "$login::useraddforms","","",%err);
#		return (msg=>"test", body=>"test");
	} else {
		%err=&loginchk("useradd", "$login::useraddforms","","",%err);
	}
	$body.=&loginhtml("useradd", "$login::useraddforms","","",%err);

	return (msg=>"\t$::resource{login_plugin_title_msg}", body=>$body);
}


sub plugin_login_openid {
	my $body;
	if($::_module_loaded{"Net::OpenID::Consumer"}) {
		if($::form{x} eq "v") {
			my %hash=Nana::OpenID::verify();
			if($hash{status} eq "login") {
				$body.=qq(<a href="$hash{url}">$hash{url}</a><br />);
				$body.=qq(<a href="?@{[&encode($::form{refer})]}">$::form{refer}</a><br />);
			} elsif($hash{status} eq "redirect") {
				&location($hash{url}, 302, $::HTTP_HEADER);
				exit;
			} elsif($hash{status} eq "cancel") {
				my($url, $name)=Nana::OpenID::getid($::form{lf("service")});
				my $res=$::resource{login_plugin_openid_cancel};
				$res=~s/\$1/$name/g;
				$body.=&loginhtml("login", "$login::loginforms1", $res, &plugin_login_openidform);
			} else {
				my($url, $id, $name)=Nana::OpenID::getid($::form{lf("service")});
				my $res=$::resource{login_plugin_openid_error};
				$res=~s/\$1/$name/g;
				$res=~s/\$2/$hash{code}/g;
				$res=~s/\$3/$hash{text}/g;
				$body.=&loginhtml("login", "$login::loginforms1", $res, &plugin_login_openidform);
			}
		} else {
			eval {
				my $url=Nana::OpenID::login($::form{lf("url")}, "refer=$::form{refer}");
				&location($url, 302, $::HTTP_HEADER);
				exit;
			};
			if($@) {
				my($url, $id, $name)=Nana::OpenID::getid($::form{lf("service")});
				my $res=$::resource{login_plugin_openid_autherr};
				$res=~s/\$1/$name/g;
				$body.=&loginhtml("login", "$login::loginforms1", $res, &plugin_login_openidform);
			}
		}
	}
	return(msg=>"\ttest", body=>$body);
}

sub plugin_login_openidform {
	my $openid;
	if($::_module_loaded{"Net::OpenID::Consumer"}) {
		foreach my $openidservice (Nana::OpenID::list()) {
			my ($url, $id, $name, $imageid, $plusid, $urlid)=Nana::OpenID::getid($openidservice, "small");
			my $refer=&encode(&encode(exists($::form{refer}) ? $::form{refer} : $::FrontPage));
			if($plusid+0 eq 0) {
				$openid.=<<EOM;
<a href="javascript:void(0);" class="openidimage" id="$imageid" onclick="return openidlogin('$::script','$refer', '@{[lf("url")]}','@{[&encode($url)]}','@{[lf("service")]}','$id');"><span>$name</span></a>
EOM
			} elsif($plusid+0 eq 2) {
				$openid.=<<EOM;
<a href="javascript:void(0);" class="openidimage" id="$imageid" onclick="return openidlogin('$::script','$refer','@{[lf("url")]}','@{[&encode($url)]}','@{[lf("service")]}','$id','','','login','@{[lf("id")]}');"><span>$name</span></a>
EOM
			} else {
				$openid.=<<EOM;
<a href="javascript:void(0);" class="openidimage" id="$imageid" onclick="return openidlogin('$::script','$refer','@{[lf("url")]}','@{[&encode($url)]}','@{[lf("service")]}','$id','login','@{[lf("id")]}');"><span>$name</span></a>
EOM
			}
		}
	}
	$openid;
}

sub plugin_login_login {
	my $body;

	%::resource=&login_read_resource("login_useradd", %::resource);

	$body.=&loginhtml("login", "$login::loginforms1", "", &plugin_login_openidform);
	$body.=&loginhtml("useradd", "$login::useraddforms");
	$body.=&loginhtml("forget", "$login::forgetforms");
	return(msg=>"\t$::resource{login_plugin_title_msg}", body=>$body);
}

sub plugin_login_logout {
	my %scookie;
	&setcookie($login::cookie_session, -1 , %scookie);
	my $url="$::script?$::form{refer}";
	&location($url, 302, $::HTTP_HEADER);
}

sub plugin_login_loginonly {
	my $body;

	my $userid=$::form{lf("id")};
	if($::form{mode} eq "login") {
		my $stat=&logindo($userid
			, $::form{lf("password")}
			, $::form{lf("password") . "_enc"}
			, $::form{lf("password") . "_token"}
		);

		my $err=$::resource{"login_plugin_login_err_$stat"};
		if($err ne "") {
			$body.=<<EOM;
<span class="error">$err</span>
EOM
		} elsif($stat ne "") {
			my %tmpuser=&readuser($stat);
			my $session=$tmpuser{session};
			my $sessionpass;
			foreach(keys %::session) {
				$sessionpass=&rnd($sessionpass . $::session{$_});
			}
			$::session{sessionpass}=$sessionpass;
			my %scookie;
			$scookie{&ln("session")}=$session;
			$scookie{&ln("sessionpass")}=$sessionpass;
			&setcookie($login::cookie_session, $login::sessionexpire , %scookie);
#			$body.="Logined $stat";
			my $url="$::script?$::form{refer}";
			&location($url, 302, $::HTTP_HEADER);
		}
	}
	$body.=&loginhtml("login", "$login::loginforms1", "", &plugin_login_openidform);
	return(msg=>"\t$::resource{login_plugin_title_msg}", body=>$body);
}

# HTML

my $plugin_login_jsadd=0;

sub loginhtml {
	my ($title, $forms, $status, $add, %err)=@_;
	my $body;
	my $bodytmp;
	my $jsform;
	my %jsform;
	foreach(split(/,/,$forms)) {
		my($fmode, $form, $res)=split(/\|/,$_);
		my ($tmp, %fjs)=&loginform($fmode, $title, $form, $res, %err);
		$bodytmp.=$tmp;
		foreach(keys %fjs) {
			$jsform{$_}.=$fjs{$_}
				if(!/^_/);
		}
		foreach(keys %fjs) {
			if(/^_/) {
				s/^_//g;
				$jsform{$_}.=$fjs{$_}
			}
		}
	}
	foreach(keys %jsform) {
		$jsform.=qq( $_=");
		$jsform.=qq(var a=true,b;);
		$jsform.=qq($jsform{$_});
		$jsform.="return a;";
		$jsform.=qq(");
	}

	$body=<<EOM if($status ne "");
<span class="error">$status</span>
EOM
	$body.=<<EOM;
<h3>$::resource{"login_plugin\_$title\_title"}</h3>
<form action="$::script" method="post" id="$title" name="$title"$jsform>
@{[&form_generate]}
<input type="hidden" name="cmd" value="login" />
<input type="hidden" name="mode" value="$title" />
<table>
$bodytmp
EOM

	my $msg=$::resource{"login_plugin\_$title\_msg"};
	$msg.=$::resource{"login_plugin\_$title\_msg\_$login::useraddpolicy"};

	$msg=&replace($msg,
		MAIL=>$::form{lf("email")},
		TITLE=>$::wiki_title,
		script=>$::script,
		DAYS=>$login::writewaitdays,
		login_plugin_useradd_msg=>$::resource{"login_plugin\_$title\_msg\_$login::useraddpolicy2"}
	);
	$body.=<<EOM;
<tr><td>&nbsp;</td><td colspan="2">$msg</td></tr>
EOM
	$body.=<<EOM if($add ne "");
<tr><td>&nbsp;</td><td>$add</td></tr>
EOM

	$body.=<<EOM;
</table>
</form>
EOM
	$body;
}

sub loginchk {
	my ($title, $forms, $status, $add, %err)=@_;

	foreach(split(/,/,$forms)) {
		my($fmode, $form, $res)=split(/\|/,$_);
		%err=&loginformchk($fmode, $title, $form, $res, %err);
	}
	%err;
}

sub jsform {
	my ($formid, $form, $class, $defclass, $inclass, $errclass, $minlength, $maxlength)=@_;
	my $js;
	my %jsform;

	my $value=$::resource{"login_plugin\_$formid\_$form\_default"};
	$value=~s/\$MIN/$minlength/g;
	$value=~s/\$MAX/$maxlength/g;

	my $errform=$login::style->{$form}->{"errform"} ? $login::style->{$form}->{"errform"} : $form;
	$errform=Nana::Login::ef($errform);
	foreach(sort keys $login::style->{$form}) {
		my $objs;
		foreach(split(/,/,$login::style->{$form}->{objs})) {
			$objs.=&lf($_) . ",";
		}
		$objs=~s/\,$//g;
		if(/^(onsubmit|onreset)/) {
			$jsform{$_}.=qq(b=$login::style->{$form}->{$_}(a,'$_','$formid','@{[lf($form)]}','$errform',this,'$objs','$value','$inclass','$defclass', '$errclass', $minlength,$maxlength););
			$jsform{$_}.=qq(a=(a==true?b:a););
		} elsif(/^on/) {
			$js.=qq( $_="return $login::style->{$form}->{$_}(a,'$_','$formid','@{[lf($form)]}','$errform',this,'$objs','$value','$inclass','$defclass', '$errclass', $minlength,$maxlength);");
		}
	}
	return($js, %jsform);
}

sub loginform {
	my($fmode, $formid, $form, $res, %err)=@_;
	my $body;
	my $value;
	my($width, $height)=split(/,/,$login::style->{$form}->{size});
	my($minlength, $maxlength)=split(/,/,$login::style->{$form}->{length});
	my $style=$login::style->{$form}->{style};

	$style.=qq( width:@{[$width]}px;) if($width+0 > 0);
	$style.=qq( height:@{[$height]}px;) if($height+0 > 0);

#	$value=$value ne "" ? $value : $::form{lf($form)};
	$value=$::form{lf($form)};

	my $class;
	my $defclass="def$fmode";
	my $inclass="input$fmode";
	my $errclass="err$fmode";

	if($value eq "" || $err{$form} ne "") {
		$value=$::resource{"login_plugin\_$formid\_$form\_default"};
		$value=~s/\$MIN/$minlength/g;
		$value=~s/\$MAX/$maxlength/g;

		$class=$defclass;
	} else {
		$class=$inclass;
	}

	my ($js, %jsform)=&jsform($formid, $form, $class, $defclass, $inclass, $errclass, $minlength, $maxlength);

	if($fmode eq "text" || $fmode eq "mail") {
		if($err{ok}) {
			$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);
			$body.=$value;
			$body.=qq(<input type="hidden" name="@{[lf($form)]}" value="$value" />);
		} else {
			$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);
			$body.=qq(<input type="text" name="@{[lf($form)]}" maxlength="$maxlength" value="$value" class="$class" @{[$style eq "" ? "" : qq( style="$style")]}$js autocomplete="off" />\n);
		}

	} elsif($fmode eq "password") {
		if($err{ok}) {
			my $f=lf($form);
#			$value=&password_decode($::form{$f}, $::form{"$f\_enc"}, $::form{"$f\_token"});
#			$value=~s/\t.*//g;
			$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);
			my $passwd_form;
			eval {
				$passwd_form=&passwordform($value, "hidden", lf($form), $::form{lf($form) . "_enc"}, $::form{lf($form) . "_token"}, $maxlength, $maxlength, "$style");
#				$passwd_form.="test:$value ($form $f)	";
			};
			$body.=$passwd_form;
			$body.=$::resource{login_plugin_useradd_hiddenpasswd};
		} else {
			$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);
			my $passwd_form;
			eval {
				$passwd_form=&passwordform($value, "", lf($form), $::form{"$login::passform\_enc"}, $::form{"login::passform\_token"}, $maxlength, $maxlength, $style, qq(class="$class" $js));
			};
			$body.=$passwd_form;
		}

	} elsif($fmode eq "date") {
		if($err{ok}) {
			$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);
			$body.=<<EOM;
$::form{lf($form . "y")}$::resource{login_plugin_useradd_date_year}
$::form{lf($form . "m")}$::resource{login_plugin_useradd_date_mon}
$::form{lf($form . "d")}$::resource{login_plugin_useradd_date_day}
<input type="hidden" name="@{[lf($form . "y")]}" value="$::form{lf($form . "y")}" />
<input type="hidden" name="@{[lf($form . "m")]}" value="$::form{lf($form . "m")}" />
<input type="hidden" name="@{[lf($form . "d")]}" value="$::form{lf($form . "d")}" />
EOM

		} else {
			$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);
			$value=$::form{lf($form . "y")};
			$body.=qq(<select name="@{[lf($form . "y")]}"@{[$style eq "" ? "" : qq( style="$style")]}>);
			my @years;
			for(my $i=1900; $i<=&date("Y"); $i++) {
				my $s="$i$::resource{login_plugin_date_year}";
				if($::lang eq "ja") {
					foreach(split(/,/,$::resource{login_plugin_date_wareki})) {
						my($start, $end, $str)=split(/\|/,$_);
						if($i >= $start && $i <= $end) {
							my $wa=$i-$start+1;
							$wa=$::resource{login_plugin_date_gannen} if($wa+0 <= 1);
							push(@years, "$i\t$s ($str$wa$::resource{login_plugin_date_year})");
						}
					}
				} else {
					push(@years, "$i\t$s");
				}
			}
			foreach(reverse @years) {
				my($y, $s)=split(/\t/, $_);
				$body.=qq(<option value="$y"@{[$y eq $value ? ' selected="selected"' : '']}>$s</option>);
			}
			$body.=qq(</select>);
			$value=$::form{lf($form . "m")};
			$body.=qq(<select name="@{[lf($form . "m")]}"@{[$style eq "" ? "" : qq( style="$style")]}>);
			for(my $i=1; $i<=12; $i++) {
				$body.=qq(<option value="$i"@{[$i eq $value ? ' selected="selected"' : '']}>$i$::resource{login_plugin_date_mon}</option>);
			}
			$body.=qq(</select>);
			$value=$::form{lf($form . "d")};
			$body.=qq(<select name="@{[lf($form . "d")]}"@{[$style eq "" ? "" : qq( style="$style")]}>);
			for(my $i=1; $i<=31; $i++) {
				$body.=qq(<option value="$i"@{[$i eq $value ? ' selected="selected"' : '']}>$i$::resource{login_plugin_date_day}</option>);
			}
			$body.=qq(</select>);
		}

	} elsif($fmode eq "mailconfirm") {
		my $value1=$::resource{"login_plugin_useradd_emailchk1_default"};
		$value1=~s/\$MIN/$minlength/g;
		$value1=~s/\$MAX/$maxlength/g;
		my $value2=$::resource{"login_plugin_useradd_emailchk2_default"};
		$value2=~s/\$MIN/$minlength/g;
		$value2=~s/\$MAX/$maxlength/g;
		if($::form{lf($form . "1")} eq ""|| $::form{lf($form . "2")} eq ""
		|| $::form{lf($form . "1")} eq $value1|| $::form{lf($form . "2")} eq $value2) {
			$class=$defclass;
		} else {
			$value1=$::form{lf($form . "1")};
			$value2=$::form{lf($form . "2")};
			$class=$inclass;
		}
		if($err{ok}+0) {
			$body.=qq(<input type="hidden" name="@{[lf($form . "1")]}" value="$value1" />\n);
			$body.=qq(<input type="hidden" name="@{[lf($form . "2")]}" value="$value2" />\n);
		} else {
			$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);

			($minlength, $maxlength)=split(/,/,$login::style->{emailchk1}->{length});
			($js, %jsform)=&jsform($formid, "emailchk1", $class, $defclass, $inclass, $errclass, $minlength, $maxlength);

			$body.=qq(<input type="text" name="@{[lf($form . "1")]}" maxlength="$maxlength" value="$value1"@{[$style eq "" ? "" : qq( style="$style")]} class="$class" $js />\n);
			$body.='@';

			($minlength, $maxlength)=split(/,/,$login::style->{emailchk2}->{length});
			($js, %jsform)=&jsform($formid, "emailchk2", $class, $defclass, $inclass, $errclass, $minlength, $maxlength);

			$body.=qq(<input type="text" name="@{[lf($form . "2")]}" maxlength="$maxlength" value="$value2"@{[$style eq "" ? "" : qq( style="$style")]} class="$class" $js />\n);
		}
	} elsif($fmode eq "captcha") {
		if($err{ok}+0 eq 0) {
			$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td colspan="2">);
			my $captcha_form;
			eval {
				$captcha_form=&plugin_captcha_form;
			};
			$body=$captcha_form eq "" ? "" : $body . $captcha_form;
		}
	} elsif($fmode eq "select") {
		my $sel=$::resource{$res} eq "" ? $res : $::resource{$res};
		$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);
		if($err{ok}) {
			foreach(split(/,/,$sel)) {
				my($n, $v)=split(/\|/,$_);
				if($n eq $value) {
					$body.=$v;
				}
			}
			$body.=qq(<input type="hidden" name="@{[lf($form)]}" value="$value" />);
		} else {
			$body.=qq(<select name="@{[lf($form)]}"@{[$style eq "" ? "" : qq( style="$style")]}>);
			foreach(split(/,/,$sel)) {
				my($n, $v)=split(/\|/,$_);
				if($n eq $value) {
					$body.=qq(<option value="$n" selected="selected">$v</option>);
				} else {
					$body.=qq(<option value="$n">$v</option>);
				}
			}
			$body.=qq(</select>\n);
		}
	} elsif($fmode eq "radio") {
	} elsif($fmode=~/submit/) {
		my $pform=$fmode eq "submit" ? lf("password") : lf("pass1") . "," . lf("pass2");
		my $sel;
		$body.=qq(<tr><td>$::resource{"login_plugin\_$formid\_$form\_title"}</td><td>);
		$sel=$::resource{"$res\_back"} eq "" ? $res : $::resource{"$res\_back"};
		my($tmpbody, $tmpjs)=&plugin_login_submitbutton($formid, lf("back"), $pform, $sel);
		if($err{ok}) {
			$body.=$tmpbody;
			$jsform{onsubmit}=$tmpjs;
		}
		$sel=$::resource{$res} eq "" ? $res : $::resource{$res};
		if($err{ok}) {
			my($tmpbody, $tmpjs)=&plugin_login_submitbutton($formid, lf("$form" . "2"), $pform, $sel);
			$body.=$tmpbody;
			$jsform{onsubmit}=$tmpjs;

		} else {
			my($tmpbody, $tmpjs)=&plugin_login_submitbutton($formid, lf("$form"), $pform, $sel);
			$body.=$tmpbody;
			$jsform{onsubmit}=$tmpjs;
		}
	}
	$body.=qq(</td>);
	if(!$err{ok}+0) {
		$body.=qq(<td><span id="@{[Nana::Login::ef($form)]}" class="error">$err{$form}</span></td>);
	}
	if($err{ok}) {
		$jsform{onsubmit}="";
	}
	return ($body eq "" ? "" : "$body</tr>\n", %jsform);
}

sub loginformchk {
	my($fmode, $formid, $form, $res, %err)=@_;
	my($minlength, $maxlength)=split(/,/,$login::style->{$form}->{length});
	my $value=$::form{lf($form)};
	my $chkmethod=undef;
	if(defined($login::style->{$form}->{check})) {
		$chkmethod=$login::style->{$form}->{check};
	}

	if($fmode eq "text" || $fmode eq "mail") {
		if($minlength+0 > 0) {
			if(length($value) eq 0) {
				$err{$form}=$::resource{"login_plugin_useradd_$form\_noinput"};
				$err{ok}=0;
			}
		}
		if($err{$form} eq "" && $minlength+0 > 0 && $maxlength+0 > 0) {
			if(length($value) < $minlength || length($value) > $maxlength) {
				$err{$form}=$::resource{"login_plugin_useradd_$form\_length"};
				$err{$form}=~s/\$MIN/$minlength/g;
				$err{$form}=~s/\$MAX/$maxlength/g;
				$err{ok}=0;
			}
		}
	}
	if($fmode eq "password") {
		my $f=lf($form);
		$value=&password_decode($::form{$f}, $::form{"$f\_enc"}, $::form{"$f\_token"});
		$value=~s/\t.*//g;
		if($minlength+0 > 0) {
			if(length($value) eq 0) {
				$err{$form}=$::resource{"login_plugin_useradd_$form\_noinput"};
				$err{ok}=0;
			}
		}
		if($err{$form} eq "" && $minlength+0 > 0 && $maxlength+0 > 0) {
			if(length($value) < $minlength || length($value) > $maxlength) {
				$err{$form}=$::resource{"login_plugin_useradd_$form\_length"};
				$err{$form}=~s/\$MIN/$minlength/g;
				$err{$form}=~s/\$MAX/$maxlength/g;
				$err{ok}=0;
			}
		}
	}
	if($chkmethod ne undef) {
		%err=&$chkmethod($form, $value, %err);
		$err{ok}=0 if($err{$form} ne "");
	}

	%err;
}

sub plugin_login_check_userid {
	my($f, $s, %err)=@_;
	&load_wiki_module("write");
	my $flg=0;
	$flg=1 if(&disablewords("useradd", $s, $::disablewords{ja},1));
	$flg=1 if(&disablewords("useradd", $s, $::disablewords,1));
	$flg=1 if(&disablewords("useradd", $s, $::disablewords_username{ja},1));
	$flg=1 if(&disablewords("useradd", $s, $::disablewords_username,1));
	$err{$f}=$::resource{"login_plugin_useradd_$f\_disable"}
		if($flg);
	%err;
}
sub plugin_login_check_password {
	my($f, $s, %err)=@_;
	%err;
}
sub plugin_login_check_newpass {
	my($f, $s, %err)=@_;
	return %err if($err{$f} ne "");
	if($::form{lf("pass1")} ne $::form{lf("pass2")}) {
		$err{$f}=$::resource{"login_plugin_useradd_$f\_err"};
	} elsif($s=~/[\,\=\\\$\'\"]/) {
		$err{$f}=$::resource{"login_plugin_useradd_$f\_ignorestr"};
	} else {
		my $flg=0;
		$flg++ if($s=~/[A-Za-z]/);
		$flg++ if($s=~/[0-9]/);
		if($flg < 2) {
			$err{$f}=$::resource{"login_plugin_useradd_$f\_char"};
		}
	}
	%err;
}
sub plugin_login_check_email {
	my($f, $s, %err)=@_;
	return %err if($err{"email"} ne "");

	%::resource=&login_read_resource("login_mailaddr", %::resource);

	if($::form{lf("email")} ne
		$::form{lf("emailchk1")} . '@' . $::form{lf("emailchk2")}) {
		$err{$f}=$::resource{"login_plugin_useradd_email_diff"};
	}
	if($::form{lf("email")}!~/$::ismail/o) {
		$err{$f}=$::resource{"login_plugin_useradd_email_err"};
	}
	my @mx;
	if(&load_module("Net::DNS")) {
		@mx=Net::DNS::mx($::form{lf("emailchk2")});
		$err{$f}=$::resource{"login_plugin_useradd_email_notdomain"}
			if($#mx < 0);
	}

	foreach("mobile", "sp", "msnlive", "freemail") {
		%err=&chkmaildomain($_, $f, $::form{lf("emailchk2")}, %err);
	}

	%err;
}

sub chkmaildomain {
	my($m, $f, $domain, %err)=@_;
	my $list=$::resource{"login_$m"};
	my $flg=0;
	my @mx;
	if(&load_module("Net::DNS")) {
		@mx=Net::DNS::mx($::form{lf("emailchk2")});
	}

	foreach my $l(split(/\n/,$list)) {
		$flg=1 if($domain=~/$l/);
		$flg=1 if($l=~/$domain/);
		foreach my $mx(@mx) {
			my $m=$mx->exchange;
			$flg=1 if($l=~/$m/);
			$flg=1 if($m=~/$l/);
		}
	}
	$err{$f}=$::resource{"login_plugin_useradd_email_$m\_match_pc"} if($flg);
#	$err{$f}=$::resource{"login_plugin_useradd_email_$m\_match_sp"} if($flg);
#	$err{$f}=$::resource{"login_plugin_useradd_email_$m\_match_mobile"} if($flg);
	%err;
}

1;
