######################################################################
# @@HEADER2_NANAMI@@
######################################################################
# Usage:
# #popup(, NG Page or URL, OK Button, NG Button, width, height)
######################################################################

use strict;

$popoupcookie::okbutton;
$popoupcookie::ngbutton;
$popoupcookie::okmove;
$popoupcookie::ngmove;
$popoupcookie::w;
$popoupcookie::h;

sub plugin_popoupcookie_convert {
	my($okmove, $ngmove, $okbutton, $ngbutton, $w, $h)=split(/,/,shift);

	if($html::nofreezeexec eq 0) {
		return ' ' if(!&is_frozen($::form{mypage}));
	}
	$popoupcookie::okmove=$okmove;
	$popoupcookie::ngmove=$ngmove;
	$popoupcookie::okbutton=$okbutton;
	$popoupcookie::ngbutton=$ngbutton;
	$popoupcookie::w=$w;
	$popoupcookie::h=$h;

	$::linedata="";
	$::linesave=1;
	$::eom_string="#popoupcookie";
	$::exec_inlinefunc=\&plugin_popoupcookie_display;
	return ' '
}

sub plugin_popoupcookie_display {
	my($text)=@_;
	my $html=<<EOM;
@{[&text_to_html($text)]}
<form>
@{[&plugin_popoupcookie_link($popoupcookie::okmove, $popoupcookie::okbutton)]}
@{[&plugin_popoupcookie_link($popoupcookie::ngmove, $popoupcookie::ngbutton)]}
</form>
EOM

	$html=~s/[\r\n]//g;
$::IN_JSHEAD.=<<EOM;
PopupOpen('$html', $popoupcookie::w, $popoupcookie::h);
EOM
	return ' ';
}

sub plugin_popoupcookie_link {
	my($link, $button)=@_;
	my $url=$link eq "" ? "" : $link=~/$::isurl/ ? $link : "$::basehref" . &make_cookedurl($link);
	return <<EOM;
<input type="button" value="$button" onclick="PopupClose(\\'$url\\');" onkeypress="PopupClose(\\'$url\\');" />
EOM
}

1;

__DATA__

sub plugin_popupcookie_usage {
	return {
		name => 'popupcookie',
		version => '1.0',
		type => 'convert',
		author => '@@NANAMI@@',
		syntax => '#popoupcookie(, NG Page or URL, OK Button, NG Button, width, height) to eom of #popoupcookie',
		description => 'popup with saved browser cookie',
		description_ja => 'cookie¸ƽݥåץåפ򤹤',
		example => '#popoupcookie(, NG Page or URL, OK Button, NG Button, width, height)',
	};
}

1;
__END__

=head1 NAME

popoupcookie.inc.pl - PyukiWiki Plugin

=head1 SYNOPSIS

 #popoupcookie(, NG Page or URL, OK Button, NG Button, width, height)
 wiki string
 wiki string
 ...
 #popupcookie

=head1 DESCRIPTION

Display popup message with saving cookie control.

=back

=head1 SEE ALSO

=over 4

=item PyukiWiki/Plugin/Standard/popoupcookie

L<@@BASEURL@@/PyukiWiki/Plugin/Standard/popoupcookie/>

=item PyukiWiki CVS

L<@@CVSURL@@/PyukiWiki-Devel/plugin/popoupcookie.inc.pl>

=back

=head1 AUTHOR

=over 4

=head1 AUTHOR

=over 4

@@AUTHOR_NANAMI@@

@@AUTHOR_PYUKI@@

=back

=head1 LICENSE

@@LICENSE_NANAMI@@

=cut
