######################################################################
# @@HEADER4_NANAMI@@
######################################################################

use 5.008100;

require "../xsmake/pyukiwikixs.pl";
my $xsinclude="xsinclude.h";
my $xsdef="xsdef.h";
my $xsbuild="xsbuild.h";
my $tst="pyukiwiki.xslib.test";

my $includes=<<EOM;
stdio.h
stdlib.h
string.h
stddef.h
ctype.h
time.h
regex.h
EOM

&mkxsbuild;
&includecheck;
&mkxsdef;
&mkmakefile;

sub includecheck {
	my $ccpath=&cc("cmd");
	unlink($xsinclude);
	open(W, ">$xsinclude");
	print W "/* Auto generated by Makefile.PL */\n\n";
	close(W);

	foreach my $h (split(/\n/,$includes)) {
		my $flg=0;
		foreach my $headers(split(/,/,$h)) {
			print "Check $headers - ";
			my $testsrc=<<EOM;
#include <$headers>

int main(void) {
}
EOM
			&writefile("$tst.c", $testsrc);
			my ($p, $o)=&execchk("$tst.c", $ccpath, " ");
			unlink("$tst.o");
			unlink("$tst.c");
			unlink("a.out");
			if($p ne "") {
				open(W, ">>$xsinclude")||die;
				print W "#include <$h>\n";
				close(W);
				$flg=1;
				print "Found\n";
				last;
			} else {
				print "Not found\n";
			}
		}
		if($flg eq 0) {
			die "Include file not found $h";
		}
	}
}

sub mkxsbuild {
	open (W, ">$xsbuild")||die;
	foreach(/:/,$ENV{PATH}) {
		if(-r "$_/uname") {
			$uname=`$_/uname`;
		}
	}
	$uname="Can't detect" if($uname eq "");

	my ($sec, $min, $hour, $mday, $mon, $year,
		$wday, $yday, $isdst) = localtime;
	$dt=sprintf("%04d-%02d-%02d %02d:%02d:%02d"
		, $year+1900,$mon+1,$mday,$hour,$min,$sec);

	print W <<EOM;
#define	XS_BUILD_ON	"$uname"
#define	XS_BUILD_DT	"$dt"
EOM
	close(W);
}

sub mkxsdef {
	my @c;
	opendir(DIR, ".");
	while(($file=readdir(DIR))) {
		next if($file eq "." || $file eq "..");
		push(@c, $file) if($file=~/\.c/);
	}
	closedir(DIR);

	unlink($xsdef);
	open(W, ">$xsdef")||die;
	print W "/* Auto generated by Makefile.PL */\n\n";

#	print "Detect:";
	foreach my $file(@c) {
		open(R, "$file")||die;
		print "Detect:$file\n";
#		print " $file";
		foreach(<R>) {
			chomp;
			if(/^(void|char|int|long|long long|short|double|float)\t(.*)\{$/) {
				my $a=$1;
				my $b=$2;
				print W"extern\t$a\t$b;\n";
			}
		}
		close(R);
	}
#	print "\n";
	close(W);
}

sub mkmakefile {
	my @h;
	my @c;

	my $cc=&cc("cmd");
	my $opt=&cc("opt");

	print "Detect compiler $cc $opt\n";
	opendir(DIR, ".");
	while(($file=readdir(DIR))) {
		next if($file eq "." || $file eq "..");

		push(@h, $file) if($file=~/\.h/);
		push(@c, $file) if($file=~/\.c/);
	}
	closedir(DIR);

	open(W, ">Makefile")||die;
	print W "# Auto generated by Makefile.PL\n\n";
	print W "CSRCS=";
	foreach(@c) {
		print W "$_ ";
	}
	print W "\n";

	print W "HEADS=";
	foreach(@h) {
		print W "$_ ";
	}
	print W "\n";

	print W <<EOM;
COBJS=\$(CSRCS:.c=.o)
CASMS=\$(CSRCS:.c=.s)
TARGET=libxslib.a

CC=$cc
COPTFLAGS=$opt
CFLAGS=-c
AR=ar rv

.c.o:
	\${CC} \${COPTFLAGS} \${CFLAGS} -o \$\@ \$<
.c.s:
	\${CC} \${COPTFLAGS} -S -o \$\@ \$<

all:\${TARGET} \${CASMS}

\${TARGET}:\${COBJS}
	\${AR} \${TARGET} \${COBJS}

clean:FORCE
	rm -f \${COBJS} \${CASMS} libxslib.a Makefile $xsinclude $xsdef $xsbuild

FORCE:
EOM
}
