######################################################################
# @@HEADER2_NANAMI@@
######################################################################

package	Nana::Login;
use 5.005;
use strict;
use integer;
use Exporter;
use vars qw($VERSION @ISA @EXPORTER @EXPORT_OK);
@EXPORT_OK = qw(lf ef ln);
use Nana::Crypt;
use Nana::RemoteHost;
use Nana::MD5 qq(md5_hex);

$VERSION = '0.1';

$login::logincmd_prefix="l";
$login::logincmd_errprefix="eg";

%login::logincmds=(
	service=>"s",
	url=>"r",
	session=>"x",
	sessionpass=>"z",
	id=>"i",
	userid=>"u",
	password=>"p",
	pass1=>"s7",
	pass2=>"a2",,
	passenc=>"pe",
	passtoken=>"pt",
	nickname=>"n",
	sex=>"xe",
	email=>"m",
	emailchk=>"k",
	emailchk1=>"i5",
	emailchk2=>"h2",
	birthdayy=>"bm",
	birthdaym=>"yd",
	birthdayd=>"dm",
	expire=>"ix",
	confirm=>"o",
	generate=>"g",
	token=>"t",
	submit=>"0z",
	back=>"1s",
);

sub lf {
	my($name)=@_;
	return $login::logincmd_prefix . $login::logincmds{$name} . "_$name";
}

%login::efbak;

sub ef {
	my($name)=@_;
	return $login::logincmd_errprefix . $login::logincmds{$name} . "_$name";
}

sub ln {
	my($name)=@_;
	return $login::logincmds{$name} . "_$name";
}


sub readsession {
	my($db, $session, $sessionpass)=@_;
	my %_db=%$db;
	my %s;
	my %dmy;
	foreach(split(/\n/,$_db{$session})) {
		chomp;
		my ($name,$value)=split(/=/,$_);
		$::s{$name}=$value
			if($name!~/^_/ || $sessionpass eq "admin");
	}
	if(($::s{$login::logincmds{session}} eq $session
	&& $s{$login::logincmds{sessionpass}} eq $sessionpass)
	|| $sessionpass eq "admin") {
		return %s;
	}
	return %dmy;
}

sub writesession {
	my($db, $s, $session)=@_;
	my %_db=%$db;
	my %_s=%$s;
	my %dmy;
	my %tmp;
	my $tmp;
	foreach(split(/\n/,$_db{$session})) {
		chomp;
		my ($name,$value)=split(/=/,$_);
		$tmp{$name}=$value
	}
	foreach(keys %_s) {
		$tmp{$_}=$_s{$_};
	}
	$tmp{counter}++;
	Nana::RemoteHost::get();
	$tmp{"_" . time}="$ENV{REMOTE_ADDR}\t$ENV{REMOTE_HOST}\t$ENV{HTTP_USER_AGENT}";
	$tmp{"_"}="$ENV{REMOTE_ADDR}\t$ENV{REMOTE_HOST}\t$ENV{HTTP_USER_AGENT}"
		if($tmp{"_"} eq "");

	foreach(keys %tmp) {
		$tmp.=qq($_=$tmp{$_}\n);
	}
	$_db{$session}=$tmp;
	return %dmy;
}

sub _dataread {
	my($tie, $key)=@_;

	for(my $i=0; $i < 1000; $i++) {
		my $hash=Nana::MD5::md5_hex($key . $i);
		if(exist ($$tie{$hash})) {
			foreach(split(/\n/,$$tie{$hash})) {
				my($name,$value)=split(/=/,$_);
				if($name eq "_db") {
					if($value eq $key) {
						return $hash;
					}
				}
			}
		}
	}
}

sub _datacreate {
	my($tie, $key)=@_;

	for(my $i=0; $i < 1000; $i++) {
		my $hash=Nana::MD5::md5_hex($key . $i);
		if(exist ($$tie{$hash})) {
			foreach(split(/\n/,$$tie{$hash})) {
				my($name,$value)=split(/=/,$_);
				if($name eq "_db") {
					if($value eq $key) {
						return $hash;
					}
				}
			}
		} else {
			return $hash;
		}
	}
}

sub readuser {
	my($db, $user, $admin)=@_;
	my %_db=%$db;
	my %_s;
	my %dmy;
	my $hash=&_dataread(\%_db, $user);
	foreach(split(/\n/,$_db{$hash})) {
		chomp;
		my ($name,$value)=split(/=/,$_);
		$_s{$name}=$value
			if($name!~/^_/ || $admin);
	}
	if($_s{$login::logincmds{user}} eq $user || $admin) {
		return %_s;
	}
	return %dmy;
}

sub writeuser {
	my($db, $s, $user)=@_;
	my %_db=%$db;
	my %_s=%$s;
	my %dmy;
	my %tmp;
	my $tmp;
	my $hash=&_dataread(\%_db, $user);
	foreach(split(/\n/,$_db{$hash})) {
		chomp;
		my ($name,$value)=split(/=/,$_);
		$tmp{$name}=$value
	}
	foreach(keys %_s) {
		$tmp{$_}=$_s{$_};
	}
	$tmp{counter}++;
	Nana::RemoteHost::get();
	$tmp{"_" . time}="$ENV{REMOTE_ADDR}\t$ENV{REMOTE_HOST}\t$ENV{HTTP_USER_AGENT}";
	$tmp{"_"}="$ENV{REMOTE_ADDR}\t$ENV{REMOTE_HOST}\t$ENV{HTTP_USER_AGENT}"
		if($tmp{"_"} eq "");

	foreach(keys %tmp) {
		$tmp.=qq($_=$tmp{$_}\n);
	}
	$_db{$hash}=$tmp;
	return %dmy;
}

sub createuser {
	my($db, $user)=@_;
	my %_db=%$db;
	my $hash=&_datacreate(\%_db, $user);
	$_db{$hash}="_db=$user\n";
}

sub deleteuser {
	my($db, $user)=@_;
	my %_db=%$db;
	my $hash=&_dataread(\%_db, $user);
	delete $_db{$hash};
}

sub makerndhash {
	my($s)=@_;
	if($s ne "") {
		my (@token) = ('0'..'9', 'A'..'Z', 'a'..'z');
		my $add=0;
		for(my $i=0; $i<128;) {
			my $token;
			$token=$token[(time + $add++ + $i + int(rand(62))) % 62];
			if($s!~/$token/) {
				$s.=$token;
				$i++;
			}
		}
	}
	my $ret=Nana::Crypt::encode($s, $::CryptMethod);
	$ret=~s/.*\}//g;
	return $ret;
}

1;
