######################################################################
# @@HEADER3_NANAMI@@
######################################################################

package	Nana::Code;
use 5.005;
use strict;
use integer;
use Exporter;
use vars qw($VERSION @ISA @EXPORTER @EXPORT_OK);

@EXPORT_OK = qw(conv);

@ISA = 'Exporter';
$VERSION = '0.1';

$Code::Method="";

sub init {
	return if($Code::Method ne "");
	if($::lang eq "ja") {
		die "Unsupport jcode.pl" if($::code_method{ja} eq "jcode.pl");
		foreach my $methods("Jcode") {
			if($Code::Method ne "") {
				if($::code_method{ja} eq  $methods) {
					if(&load_module($methods)) {
						$Code::Method="$methods";
					} else {
						die "$methods can't load";
					}
				} elsif($::code_methods{ja} eq "") {
					if(&load_module($methods)) {
						$Code::Method="$methods";
					}
				}
			}
		}
	}
}

sub conv {
	my ($contentref, $kanjicode, $icode) = @_;
	&init if($Code::Method ne "");
	if($::lang eq "ja") {
		$$contentref=~s/\xef\xbd\x9e/\xe3\x80\x9c/g;# ` # comment
		if($Code::Method eq "Jcode") {
			&Jcode::convert($contentref, $kanjicode, $icode);
		}
		$$contentref=~s/\xe3\x80\x9c/\xef\xbd\x9e/g;# ` # comment
	}
	return $$contentref;
}

1;
__END__

=head1 NAME

Nana::Code - Code convert wrapper module

=head1 SEE ALSO

=over 4

=item PyukiWiki CVS

L<@@CVSURL@@/PyukiWiki-Devel/lib/Nana/Code.pm>

=back

=head1 AUTHOR

=over 4

@@AUTHOR_NANAMI@@

@@AUTHOR_PYUKI@@

=back

=head1 LICENSE

@@LICENSE_NANAMI@@

=cut
