######################################################################
# @@HEADER3_NANAMI@@
######################################################################

package	Nana::Carp;
use 5.005;
use strict;
use integer;
use Exporter;

$carp::width=600;

BEGIN {
	require Carp;
	*CORE::GLOBAL::die = \&Nana::Carp::die;
	$main::SIG{__DIE__} = \&Nana::Carp::err;
	$main::SIG{__WARN__} = \&Nana::Carp::warn;
}

use vars qw($VERSION @ISA @EXPORTER @EXPORT_OK);
$VERSION = '0.1';
@EXPORT_OK = qw();

######################################################################

sub getcaller {
	my $count=0;
    my @result;
	my $evalflag=0;
	while(1) {
		my @c=caller($count++);
		last if($#c < 1);
		next if($c[3] =~ /^Nana::Carp::getcaller/);
		$evalflag=$c[3] =~ /^Nana::Carp/ ? 0 : $evalflag ? $evalflag : $c[3] eq "(eval)" ? 2 : 1;
		push(@result, "$c[0]\t$c[1]\t$c[2]\t$c[3] $evalflag\t$evalflag");
	}
	my @null;
	push(@null, "-");
	return @null if($evalflag eq 2);
	return @result;
}

sub readsrc {
	my($file, $line)=@_;
	my $buf;
	if(open(R, $file)) {
		foreach(<R>) {
			$buf.=$_;
		}
		close(R);
		my @buf;
		my $src;
		my @buf=split(/\n/,$buf);
		for(my $i=1; $i < $line + 5; $i++) {
			if($i >= $line - 3 && $i <= $line + 3) {
				$src.="$i : " . $buf[$i-1];
				 $src .="<br />";
			}
		}
		close(R);
		return $src;
	}
}

sub msg {
	my($mode, $msg, @args)=@_;
	print <<EOM;
Content-type: text/html

<html><head>
<title>PyukiWiki Runtime $mode</title>
</head>
<body>
<h1>PyukiWiki Runtime $mode</h1>
<br />
EOM

	foreach(split(/\n/,$msg)) {
		print "<strong>$_</stonrg><br />";
	}
		print <<EOM;
<hr />
<br />
<table border="1" width="$carp::width">
<tr><th colspan="5">Trace Info</th></tr>
<tr><th>Package</th><th>File</th><th>Line</th><th>Function</th></tr>
EOM
	foreach my $a(@args) {
		foreach(split(/\n/,$a)) {
			my @l=split(/\t/,$_);
			print <<EOM;
<tr><td>$l[0]</td><td>$l[1]</td><td align="right">$l[2]</td><td>$l[3]</td></tr>
EOM
			my $src=&readsrc($l[1], $l[2]);
			print <<EOM if($src ne "");
<tr><td colspan="4"><i>$src</i></td></tr>
EOM
		}
	}

	print <<EOM;
</table>
<hr />
<div align="right">
<i>PyukiWiki version $::version</i><br />
<i>Server Admin $ENV{SERVER_ADMIN}</i>
</div>
</body>
</html>
EOM
}

sub die {
	my ($msg)=@_;
	my @cal=&getcaller;
	return if($cal[0] eq "-");
	&msg("Die", $msg, @cal);
	exit;
}

sub err {
	my ($str)=@_;
	my @cal=&getcaller;
	return if($cal[0] eq "-");
	&msg("Error", $str, @cal);
	exit;
}

sub warn {
	my ($str)=@_;
	my @caller=&getcaller;
	&msg("Warning", $str, @caller);
	exit;
}

sub syntaxcheck {
	my ($s)=@_;
	my $perlpath=&perlpath;
	if(open(PIPE, "|$perlpath -c")) {
		print PIPE $s;
		close(PIPE);
		if($? eq 0) {
			return 0;
		}
	}
	return 1;
}

sub perlpath {
	my $perlpath;
	if(open(R,"$0")) {
		$perlpath=<R>;
		close(R);
		$perlpath=~s/#!//g;
		$perlpath=~s/-//g;
		$perlpath=~s/ //g;
		$perlpath=~s/[\r\n]//g;
		return $perlpath;
	}
}

1;
